﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using YamlDotNet.Serialization;
using YamlDotNet.Serialization.NamingConventions;

namespace DeviceTreeDataCollector
{
    internal class InputParameter
    {
        public string BlobFilePath { get; set; }
        public List<PropertyCollectParameter> PropertyCollectParameters { get; set; }
    }

    internal class InputParameterParser
    {
        public readonly string FilePath;
        public InputParameter Parameter { get; private set; }

        public InputParameterParser(string filePath)
        {
            FilePath = filePath;
            Parameter = null;
        }

        public void LoadParameter()
        {
            using (var input = File.OpenText(FilePath))
            {
                var deserializer = new DeserializerBuilder()
                    .IgnoreUnmatchedProperties()
                    .WithNamingConvention(new PascalCaseNamingConvention())
                    .Build();
                try
                {
                    Parameter = deserializer.Deserialize<InputParameter>(input);
                }
                catch (Exception e)
                {
                    Console.Error.WriteLine("*** YamlDotNet deserializer threw exception (Check input yml format) ***");
                    if (e.Message != null)
                    {
                        Console.WriteLine($"  Message: {e.Message}");
                    }
                    if (e.InnerException != null)
                    {
                        Console.WriteLine($"  InnerException.Message: {e.InnerException.Message}");
                    }
                    throw;
                }
            }
        }
    }
}
