﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TeamCityLogParser
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            if (args.Length != 1)
            {
                Console.Error.WriteLine("usage: TeamCityLogParser <build_log_file>");
                Environment.Exit(1);
            }

            try
            {
                ProcessTeamCityLog(args[0]);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine("内部エラー : {0}", e.Message);
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine("== Exception ==");
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine(e.ToString());

                Environment.Exit(1);
            }
        }

        /// <summary>
        /// ビルドログを記録したファイルを受付け、そこから必要な情報をパースして
        /// json ファイルに保存します。保存先のファイル名は、元のファイルに ".data.json" を足したものになります。
        /// </summary>
        /// <param name="logfile"></param>
        private static void ProcessTeamCityLog(string logfile)
        {
            var json = LogParser.ParseToJsonText(logfile);
            var outputfile = logfile + ".meta.json";

            File.WriteAllText(outputfile, json, Encoding.UTF8);
        }
    }
}
