﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace MakeDataDocument
{
    [DataContract]
    public class DataSampleDefinition
    {
        [DataMember(Name = "key", Order = 0)]
        public string Key { get; set; }
        [DataMember(Name = "x", Order = 1)]
        public string X { get; set; }
        [DataMember(Name = "y", Order = 2)]
        public string Y { get; set; }
    }

    [DataContract]
    public class DataDocumentDefinition
    {
        [DataMember(Name = "name", Order = 0)]
        public string Name { get; set; }
        [DataMember(Name = "filter", Order = 1)]
        private Dictionary<string, string> filterValue = new Dictionary<string, string>();
        public Dictionary<string, string> Filter
        {
            get { return filterValue; }
            set { filterValue = value; }
        }
        [DataMember(Name = "source", Order = 2)]
        public string SourceDirectory { get; set; }
        [DataMember(Name = "output", Order = 3)]
        public string OutputDirectory { get; set; }
        [DataMember(Name = "sample_definition", Order = 4)]
        public DataSampleDefinition DataSampleDefinition { get; set; }

        public bool CheckAcceptability(Dictionary<string, object> datalet)
        {
            if (!(datalet.ContainsKey(DataSampleDefinition.Key) &&
                datalet.ContainsKey(DataSampleDefinition.X) &&
                datalet.ContainsKey(DataSampleDefinition.Y)))
            {
                return false;
            }

            foreach (var pair in Filter)
            {
                if (!datalet.ContainsKey(pair.Key))
                {
                    return false;
                }

                if (!Regex.Match(datalet[pair.Key].ToString(), pair.Value).Success)
                {
                    return false;
                }
            }

            return true;
        }

        public static DataDocumentDefinition MakeFromJsonFile(string path)
        {
            using (var reader = new StreamReader(path))
            {
                return MakeFromJsonText(reader.ReadToEnd());
            }
        }

        public static DataDocumentDefinition MakeFromJsonText(string jsonText)
        {
            var settings = new DataContractJsonSerializerSettings();
            settings.UseSimpleDictionaryFormat = true;

            var serializer = new DataContractJsonSerializer(typeof(DataDocumentDefinition), settings);
            var stream = new MemoryStream(Encoding.UTF8.GetBytes(jsonText));

            return (DataDocumentDefinition)serializer.ReadObject(stream);
        }
    }
}
