﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static class Shogun
    {
        [DataContract]
        public class IdPairsInfo
        {
            [DataContract]
            public class IdPair
            {
                [DataMember(Name = "content_type", Order = 0)]
                public string contentType { get; set; }

                [DataMember(Name = "id", Order = 1)]
                public long nsUid { get; set; }

                [DataMember(Name = "title_id", Order = 2)]
                public string titleId { get; set; }

                [DataMember(Name = "title_ids", Order = 3)]
                public List<string> titleIds { get; set; }
            }
            [DataMember(Name = "id_pairs", Order = 0)]
            public List<IdPair> idPairs { get; set; }

            public List<string> GetNsUids()
            {
                List<string> nsUids = new List<string>();
                foreach (var pair in idPairs)
                {
                    nsUids.Add(pair.nsUid.ToString());
                }
                return nsUids;
            }
        }
    }
}
