﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;
using ContentsUploader.Assistants;

namespace ContentsUploader.Commands
{
    public class RestartDeliveryCommand : CommandBase
    {
        //! Nsp 入力
        [CommandLineOption('s', "input", DefaultValue = "", Description = "Nsp of restart-delivery setting")]
        public override string NspPathOption { get; set; }

        //! ID, Version 入力 ->
        [CommandLineOption("content-meta-id", DefaultValue = "", Description = "Content Meta ID of the restart delivery rom")]
        public override string ContentMetaIdOption { get; set; }

        [CommandLineOption("content-meta-version", DefaultValue = "", Description = "Delivery Version of the restart delivery rom")]
        public string ContentMetaVersionOption { get; set; }
        //! <-

        public override void Run()
        {
            Run("Restart Delivery");
        }

        protected override bool RunByFile(NspAccessor nsp)
        {
            var result = true;
            foreach (var content in nsp.NspInnerContent)
            {
                result &= RestartDelivery(content.ContentMetaId, content.Version);
            }
            return result;
        }

        protected override bool RunByContentMetaId()
        {
            var contentMetaId = new Id64(ContentMetaIdOption);
            var contentMetaVersion = int.Parse(ContentMetaVersionOption);
            return RestartDelivery(contentMetaId, contentMetaVersion);
        }

        private bool RestartDelivery(Id64 contentMetaId, int contentMetaVersion)
        {
            Log.WriteLine($"Restart Delivery: {contentMetaId}, {contentMetaVersion}");

            var shop = new ShopHelper(Setting.Current);
            return shop.UpdateDisableDownloadFlag(contentMetaId, contentMetaVersion, false);
        }
    }
}
