﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace CommandUtility
{
    public class TaskUtility
    {
        public static void RunTasks(params Action[] actions)
        {
            var cancelSource = new CancellationTokenSource();
            var tasks = actions.Select((action) => {
                return Task.Run(() =>
                {
                    try
                    {
                        action();
                    }
                    catch(Exception e)
                    {
                        Console.Error.WriteLine("[ERROR] " + e.Message);
                        cancelSource.Cancel();
                        throw;
                    }
                }, cancelSource.Token);
            });

            try
            {
                Task.WaitAll(tasks.ToArray(), cancelSource.Token);
            }
            catch (AggregateException es)
            {
                foreach (var e in es.InnerExceptions)
                {
                    Console.Error.WriteLine("[ERROR] " + e.Message);
                }

                throw;
            }
        }
    }
}
