﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Linq;

namespace CommandUtility
{
    public class SdkVersion
    {
        private const string VersionResourceName = "CommandUtility.NXAddonVersion.xml";

        public static string GetSdkVersion()
        {
            var assembly = (typeof(SdkVersion)).Assembly;

            if (!assembly.GetManifestResourceNames().Contains(VersionResourceName))
            {
                var names = assembly.GetManifestResourceNames();
                throw new Exception($"Found no resource data: {VersionResourceName}");
            }

            using (var versionXmlTextReader = assembly.GetManifestResourceStream(VersionResourceName))
            {
                var xml = XElement.Load(versionXmlTextReader);
                var major = (from e in xml.Descendants() where e.Name.LocalName == "Major" select e.Value).Single();
                var minor = (from e in xml.Descendants() where e.Name.LocalName == "Minor" select e.Value).Single();
                var micro = (from e in xml.Descendants() where e.Name.LocalName == "Micro" select e.Value).Single();
                var relStep = (from e in xml.Descendants() where e.Name.LocalName == "Relstep" select e.Value).Single();

                return $"{major}.{minor}.{micro}-{relStep}";
            }
        }
    }

}
