﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Management;
using System.IO;

namespace CommandUtility
{
    public class ProcessUtility
    {
        public static string GetTaskKillPath()
        {
            return Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.System), "taskkill.exe");
        }
        public static Process StartScript(string scriptPath, string workingDirectory, DataReceivedEventHandler OutputDataReceived, DataReceivedEventHandler ErrorDataReceived, string argument = null)
        {
            var info = new ProcessStartInfo()
            {
                CreateNoWindow = true,
                FileName = scriptPath,
                UseShellExecute = false,
                WorkingDirectory = workingDirectory,
                RedirectStandardError = true,
                RedirectStandardOutput = true,
                Arguments = argument
            };

            var p = Process.Start(info);
            p.OutputDataReceived += OutputDataReceived;
            p.ErrorDataReceived += ErrorDataReceived;
            p.BeginOutputReadLine();
            p.BeginErrorReadLine();
            return p;
        }
        public static void KillProcess(Process process)
        {
            using (var killProcess = new System.Diagnostics.Process())
            {
                killProcess.StartInfo.FileName = GetTaskKillPath();
                killProcess.StartInfo.Arguments = string.Format("/PID {0} /T /F", process.Id);
                killProcess.StartInfo.CreateNoWindow = true;
                killProcess.StartInfo.UseShellExecute = false;
                killProcess.Start();
                killProcess.WaitForExit();
            }
        }
        public static void TerminateProcess(Process p)
        {
            if (p != null)
            {
                try
                {
                    KillProcess(p);
                    p.Dispose();
                    p = null;
                }
                catch (InvalidOperationException)
                {
                    return;
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }
        public static int WaitProcess(Process p)
        {
            p.WaitForExit();
            int exitCode = p.ExitCode;
            p.Dispose();
            p = null;

            return exitCode;
        }

        public static void KillProcessBasedOnCommandLineArgument(string processName, string argument)
        {
            var mc = new ManagementClass("Win32_Process");
            foreach (var process in mc.GetInstances())
            {
                if (String.Compare(processName, process["Name"].ToString(), true) == 0)
                {
                    var commandLine = process["CommandLine"]?.ToString();
                    if (commandLine.Contains(argument))
                    {
                        var pid = (System.UInt32)process["ProcessId"];
                        var processes = System.Diagnostics.Process.GetProcesses();
                        var target = processes.Where(x => x.Id == pid).FirstOrDefault();
                        KillProcess(target);
                    }
                }
            }
        }
    }
}
