﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using Nintendo.Foundation.IO;

namespace CommandUtility
{
    public abstract class SubCommandCommon
    {
        public abstract int Run();

        public int RunCommand(Func<int> action)
        {
            return action();
        }

        public static SubCommandCommon FindActivatedSubCommand(object commandContainer)
        {
            var containerType = commandContainer.GetType();
            foreach (var property in containerType.GetProperties())
            {
                if (0 < property.GetCustomAttributes<CommandLineSubCommandAttribute>(true).Count())
                {
                    var subCommandValue = property.GetValue(commandContainer);
                    if (subCommandValue is SubCommandCommon && subCommandValue != null)
                    {
                        return (SubCommandCommon)subCommandValue;
                    }
                }
            }

            throw new Exception("Found no subcommands");
        }
    }

    public class MultiCommandRunner<SubCommandClass> where SubCommandClass : class, new()
    {
        public static int Run(string[] args)
        {
            try
            {
                SubCommandClass parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<SubCommandClass>(args, out parsed))
                {
                    return 1;
                }

                return SubCommandCommon.FindActivatedSubCommand(parsed).Run();
            }
            catch (Exception exception)
            {
                PrintException(exception);
                return 1;
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.Write("StackTrace: {0}", exception.StackTrace);
        }
    }
}
