﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;
    using System.IO;
    using ElfLibrary;

    /// <summary>
    /// ELF 32bit セクションヘッダクラス
    /// </summary>
    public class Elf32SectionHeader : ElfSectionHeader
    {
        /// <summary>
        /// ELF セクションヘッダのサイズ
        /// </summary>
        public const ushort Elf32HeaderSize = 40;

        /// <summary>
        /// ファイルから SectionHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            Name = reader.ReadUInt32();
            Type = reader.ReadUInt32();
            Flags = reader.ReadUInt32();
            Address = reader.ReadUInt32();
            Offset = reader.ReadUInt32();
            Size = reader.ReadUInt32();
            Link = reader.ReadUInt32();
            Info = reader.ReadUInt32();
            AddressAlign = reader.ReadUInt32();
            EntrySize = reader.ReadUInt32();
        }

        /// <summary>
        /// ファイルに SectionHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            checked
            {
                writer.WriteUInt32(Name);
                writer.WriteUInt32(Type);
                writer.WriteUInt32((uint)Flags);
                writer.WriteUInt32((uint)Address);
                writer.WriteUInt32((uint)Offset);
                writer.WriteUInt32((uint)Size);
                writer.WriteUInt32((uint)Link);
                writer.WriteUInt32((uint)Info);
                writer.WriteUInt32((uint)AddressAlign);
                writer.WriteUInt32((uint)EntrySize);
            }
        }
    }
}
