﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;

    /// <summary>
    /// Elf 32-bit RelocationAddendEntry クラス
    /// </summary>
    public class Elf32RelocationAddendEntry : ElfRelocationAddendEntry
    {
        public const ushort HeaderSize = 12;

        /// <summary>
        /// ファイルから SymbolHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            R_Offset = reader.ReadUInt32();
            R_Info = reader.ReadUInt32();
            R_Addend = checked((int)reader.ReadUInt32());
        }

        /// <summary>
        /// ファイルに SymbolHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            checked
            {
                writer.WriteUInt32((uint)R_Offset);
                writer.WriteUInt32((uint)R_Info);
                writer.WriteUInt32((uint)R_Addend);
            }
        }
    }
}
