﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;

    /// <summary>
    /// Elf 32-bit ProgramHeader クラス
    /// </summary>
    public class Elf32ProgramHeader : ElfProgramHeader
    {
        public const ushort Elf32HeaderSize = 32;

        /// <summary>
        /// ProgramHeader を読み込みます。
        /// </summary>
        /// <param name="reader">ElfBinaryReader</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            P_Type = reader.ReadUInt32();
            P_Offset = reader.ReadUInt32();
            P_Vaddr = reader.ReadUInt32();
            P_Paddr = reader.ReadUInt32();
            P_FileSz = reader.ReadUInt32();
            P_MemSz = reader.ReadUInt32();
            P_Flags = reader.ReadUInt32();
            P_Align = reader.ReadUInt32();
        }

        /// <summary>
        /// ProgramHeader を書きだします。
        /// </summary>
        /// <param name="reader">ElfBinaryWriter</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            checked
            {
                writer.WriteUInt32(P_Type);
                writer.WriteUInt32((uint)P_Offset);
                writer.WriteUInt32((uint)P_Vaddr);
                writer.WriteUInt32((uint)P_Paddr);
                writer.WriteUInt32((uint)P_FileSz);
                writer.WriteUInt32((uint)P_MemSz);
                writer.WriteUInt32((uint)P_Flags);
                writer.WriteUInt32((uint)P_Align);
            }
        }
    }
}
