﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Bin2Obj
{
    using System;
    using System.IO;

    public class ElfDataSectionParameter
    {
        public byte[] Data { get; private set; }
        public string BinaryFileName { get; private set; }
        public bool IsWritable { get; private set; }
        public string SectionRwData { get; private set; }
        public string SectionRoData { get; private set; }
        public string SymbolBegin { get; private set; }
        public string SymbolEnd { get; private set; }
        public uint Align { get; private set; }

        public ElfDataSectionParameter(string binaryFileName, bool isWritable,
            string sectionRwData, string sectionRoData, string symbolBegin, string symbolEnd,
            uint align, byte[] data = null)
        {
            this.BinaryFileName = binaryFileName;
            this.IsWritable = isWritable;
            this.SectionRwData = sectionRwData;
            this.SectionRoData = sectionRoData;
            this.SymbolBegin = symbolBegin;
            this.SymbolEnd = symbolEnd;
            this.Align = align;
            this.Data = data;
        }

        /// <summary>
        /// ファイルの内容をデータセクションのデータとして読み込む
        /// </summary>
        /// <param name="fs">入力ファイルストリーム</param>
        public void ReadDataSection(FileStream fs)
        {
            using (BinaryReader reader = new BinaryReader(fs))
            {
                this.Data = new byte[fs.Length];
                this.Data = reader.ReadBytes((int)fs.Length);
            }
        }
    }
}
