﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <string>
#include <msclr/marshal.h>

#include "lz4.h"

namespace Nintendo { namespace Authoring { namespace Lz4Library {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

    public ref class Lz4
    {
    public:
        static int CompressDefault(array<Byte>^ source, array<Byte>^ dest, int sourceSize, int maxDestSize)
        {
            pin_ptr<unsigned char> pinSrc = &source[0];
            pin_ptr<unsigned char> pinDest = &dest[0];
            return LZ4_compress_default(reinterpret_cast<char*>(pinSrc), reinterpret_cast<char*>(pinDest), sourceSize, maxDestSize);
        }

        static int DecompressSafe(array<Byte>^ source, int sourceOffset, array<Byte>^ dest, int destOffset, int compressedSize, int maxDecompressedSize)
        {
            pin_ptr<unsigned char> pinSrc = &source[sourceOffset];
            pin_ptr<unsigned char> pinDest = &dest[destOffset];
            return LZ4_decompress_safe(reinterpret_cast<char*>(pinSrc), reinterpret_cast<char*>(pinDest), compressedSize, maxDecompressedSize);
        }
    };

}}}
