﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/image/image_JpegEncoder.h>
#include <nn/nn_Abort.h>
#include <memory>

#define NN_JPEG_STATUS_DO(s) { \
auto status = (s); \
if (status != nn::image::JpegStatus::JpegStatus_Ok) \
{\
    return Nintendo::Authoring::ImageLibrary::JpegStatusUtil::ConvertJpegStatus(status);\
}\
}

namespace Nintendo { namespace Authoring { namespace ImageLibrary {
    public enum class JpegStatus {
        Ok,
        WrongFormat,
        UnsupportedFormat,
        OutOfMemory,
        ShortOutput,
        OutputOverabounds,
    };

public ref class JpegStatusUtil {
public:
    static JpegStatus ConvertJpegStatus(nn::image::JpegStatus status)
    {
        switch (status)
        {
        case nn::image::JpegStatus_Ok:
            return JpegStatus::Ok;
            break;
        case nn::image::JpegStatus_WrongFormat:
            return JpegStatus::WrongFormat;
            break;
        case nn::image::JpegStatus_UnsupportedFormat:
            return JpegStatus::UnsupportedFormat;
            break;
        case nn::image::JpegStatus_OutOfMemory:
            return JpegStatus::OutOfMemory;
            break;
        case nn::image::JpegStatus_ShortOutput:
            return JpegStatus::ShortOutput;
            break;
        case nn::image::JpegStatus_OutputOverabounds:
            return JpegStatus::OutputOverabounds;
            break;
        default:
            NN_ABORT("Invalid jpeg status.\n");
            break;
        }
    }
};


}}}
