﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_BUILD_AUTHORING_TOOL
#error
#else
#define USE_DUMMY_ABORT
#include <cstdlib>
#define NN_ABORT(...)              \
    {                              \
        std::abort();              \
    }
#define NN_ABORT_UNLESS(condition, ...)         \
    {                                           \
        if( condition == false )                \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_NOT_NULL(pointer)       \
    {                                           \
        if( pointer == nullptr )                \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_EQUAL(lhs, rhs)         \
    {                                           \
        if( lhs != rhs )                        \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_NOT_EQUAL(lhs, rhs)     \
    {                                           \
        if( lhs == rhs )                        \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_LESS(lhs, rhs)          \
    {                                           \
        if( lhs >= rhs )                        \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_LESS_EQUAL(lhs, rhs)    \
    {                                           \
        if( lhs > rhs )                         \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_GREATER(lhs, rhs)       \
    {                                           \
        if( lhs <= rhs )                        \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_GREATER_EQUAL(lhs, rhs) \
    {                                           \
        if( lhs < rhs )                         \
        {                                       \
            std::abort();                       \
        }                                       \
    }
#define NN_ABORT_UNLESS_RANGE(value, begin, end)    \
    {                                               \
        if(!((begin <= value) && (value < end)))    \
        {                                           \
            std::abort();                           \
        }                                           \
    }
#define NN_ABORT_UNLESS_RESULT_SUCCESS(result)  \
        NN_ABORT_UNLESS((result).IsSuccess())
#endif
