﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <string>
#include <msclr/marshal.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fssystem/fs_PartitionFileSystem.h>

#include "../Util/DeclareAlive.h"
#include "Sha256PartitionFileSystemArchiveReader.h"
#include "NintendoContentArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;
using namespace nn::fssystem;

    public ref class XciPartitionReader : public Sha256PartitionFileSystemArchiveReader
    {
    public:
        XciPartitionReader(Stream^ stream) : Sha256PartitionFileSystemArchiveReader(stream)
        {
            GC::KeepAlive(this);
        }

        NintendoContentArchiveReader^ OpenNintendoContentArchiveReader(String^ fileName, IKeyGenerator^ keyGenerator)
        {
            std::shared_ptr<fs::IStorage> storage;
            this->OpenFileStorage(&storage, fileName);
            return Util::ReturnAndDeclareAlive(this, gcnew NintendoContentArchiveReader(std::move(storage), keyGenerator));
        }

    internal:
        XciPartitionReader(std::shared_ptr<fs::IStorage> storage) : Sha256PartitionFileSystemArchiveReader(storage)
        {
            GC::KeepAlive(this);
        }
    };

    public ref class XciReader : public Sha256PartitionFileSystemArchiveReader
    {
    public:
        XciReader(Stream^ stream, array<Byte>^ hash) : Sha256PartitionFileSystemArchiveReader(stream, hash)
        {
            GC::KeepAlive(this);
        }

        XciPartitionReader^ OpenXciPartitionReader(String^ fileName)
        {
            std::shared_ptr<fs::IStorage> storage;
            this->OpenFileStorage(&storage, fileName);
            return Util::ReturnAndDeclareAlive(this,  gcnew XciPartitionReader(std::move(storage)));
        }
    };

}}}
