﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fssystem/save/fs_JournalIntegritySaveDataFileSystemDriver.h>
#include <nn/fssystem/save/fs_IntegritySaveDataFileSystemDriver.h>

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;

using namespace nn;

    public ref class SaveDataUtils
    {
    public:
        static const int32_t BlockSize = 16 * 1024;
        static Int64 QuerySaveDataTotalSize(Int64 availableSize, Int64 journalSize)
        {
            auto params = fssystem::save::JournalIntegritySaveDataFileSystemDriver::SetUpSaveDataParameters(BlockSize, availableSize, journalSize);
            int64_t outValue = 0;
            auto result = fssystem::save::JournalIntegritySaveDataFileSystemDriver::QueryTotalSize(&outValue, params.blockSize, params.countExpandMax, params.paramDuplex, params.paramIntegrity, params.countDataBlock, params.countJournalBlock);
            if (result.IsFailure())
            {
                throw gcnew ArgumentException(String::Format("Invalid save data size. 0x{0:X8}", result.GetInnerValueForDebug()));
            }
            return outValue;
        }

        static Int64 QueryTemporarySaveDataTotalSize(Int64 availableSize)
        {
            auto params = fssystem::save::IntegritySaveDataFileSystemDriver::SetUpSaveDataParameters(BlockSize, availableSize);
            int64_t outValue = 0;
            auto result = fssystem::save::IntegritySaveDataFileSystemDriver::QueryTotalSize(&outValue, params.blockSize, params.paramIntegrity, params.countDataBlock);
            if (result.IsFailure())
            {
                throw gcnew ArgumentException(String::Format("Invalid save data size. 0x{0:X8}", result.GetInnerValueForDebug()));
            }
            return outValue;
        }
    };

}}}
