﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fssystem/fs_PartitionFileSystemMeta.h>
#include <FileSystemInfo.h>
#include <SourceInterface.h>
#include <nn/fs/fs_Directory.h>
#include <msclr/marshal.h>
#include <vector>

#include "../Util/DeclareAlive.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::Collections;
using namespace System::Runtime::InteropServices;
using namespace msclr::interop;

    public ref class PartitionFileSystemInfo : public FileSystemInfo
    {
    public:
        int version;
        value class EntryInfo
        {
        public:
            String^ type;
            String^ name;
            UInt64 size;
            UInt64 offset;
            String^ path;
            UInt64 hashTargetOffset;
            UInt32 hashTargetSize;
            SourceInterface^ sourceInterface;

            static EntryInfo Make(String^ name, UInt64 size, UInt64 offset)
            {
                EntryInfo entry;
                entry.name = name;
                entry.size = size;
                entry.offset = offset;
                return entry;
            }

            static EntryInfo Make(String^ name, UInt64 size, UInt64 offset, UInt64 hashTargetOffset, UInt32 hashTargetSize)
            {
                EntryInfo entry;
                entry.name = name;
                entry.size = size;
                entry.offset = offset;
                entry.hashTargetOffset = hashTargetOffset;
                entry.hashTargetSize = hashTargetSize;
                return entry;
            }
        };
        Generic::List<EntryInfo>^ entries;
        PartitionFileSystemInfo()
        {
            entries = gcnew Generic::List<EntryInfo>();
            GC::KeepAlive(this);
        }
    };

    public interface class IPartitionFileSystemMeta
    {
    public:
        array<Byte>^ Create(PartitionFileSystemInfo^ fileSystemInfo);
    };

    public ref class Sha256PartitionFileSystemMeta : IPartitionFileSystemMeta
    {
    public:
        static Int64 GetEntryHashOffset(int index)
        {
            const Int64 PartitionFsHeaderSize = 16;
            return PartitionFsHeaderSize + sizeof(nn::fssystem::detail::Sha256PartitionFileSystemFormat::PartitionEntry) * index + offsetof(struct nn::fssystem::detail::Sha256PartitionFileSystemFormat::PartitionEntry, hash);
        }

        virtual array<Byte>^ Create(PartitionFileSystemInfo^ fileSystemInfo)
        {
            nn::fssystem::Sha256PartitionFileSystemMeta metaEditor;

            int numEntries = fileSystemInfo->entries->Count;
            std::vector<nn::fssystem::Sha256PartitionFileSystemMeta::FileEntryForConstruct> internalEntryArray(numEntries);
            for(int i = 0; i < numEntries; i++)
            {
                internalEntryArray[i].offset = fileSystemInfo->entries[i].offset;
                internalEntryArray[i].size = fileSystemInfo->entries[i].size;

                pin_ptr<const wchar_t> pWchar = PtrToStringChars(fileSystemInfo->entries[i].name);
                auto ret = ::WideCharToMultiByte(CP_UTF8, 0, pWchar, -1, internalEntryArray[i].name, sizeof(internalEntryArray[i].name), nullptr, nullptr);
                if (ret == 0)
                {
                    throw gcnew ArgumentException(String::Format("Failed to convert UTF8 to multi byte."));
                }
                pWchar = nullptr;

                internalEntryArray[i].hashTargetOffset = fileSystemInfo->entries[i].hashTargetOffset;
                internalEntryArray[i].hashTargetSize = fileSystemInfo->entries[i].hashTargetSize;
            }

            size_t bufferSize = 0;
            metaEditor.QueryMetaDataSize(&bufferSize, internalEntryArray.data(), internalEntryArray.size());

            array<unsigned char>^ buf = gcnew array<unsigned char>(bufferSize);
            {
                pin_ptr<unsigned char> ptr = &buf[0];
                metaEditor.ConstructMetaData(ptr, bufferSize, internalEntryArray.data(), internalEntryArray.size());
                ptr = nullptr;
            }

            return Util::ReturnAndDeclareAlive(this, buf);
        }
    };

    public ref class PartitionFileSystemMeta : IPartitionFileSystemMeta
    {
    public:
        virtual array<Byte>^ Create(PartitionFileSystemInfo^ fileSystemInfo)
        {
            nn::fssystem::PartitionFileSystemMeta metaEditor;

            int numEntries = fileSystemInfo->entries->Count;
            std::vector<nn::fssystem::PartitionFileSystemMeta::FileEntryForConstruct> internalEntryArray(numEntries);
            for(int i = 0; i < numEntries; i++)
            {
                internalEntryArray[i].offset = fileSystemInfo->entries[i].offset;
                internalEntryArray[i].size = fileSystemInfo->entries[i].size;

                pin_ptr<const wchar_t> pWchar = PtrToStringChars(fileSystemInfo->entries[i].name);
                auto ret = ::WideCharToMultiByte(CP_UTF8, 0, pWchar, -1, internalEntryArray[i].name, sizeof(internalEntryArray[i].name), nullptr, nullptr);
                if (ret == 0)
                {
                    throw gcnew ArgumentException(String::Format("Failed to convert UTF8 to multi byte."));
                }
                pWchar = nullptr;
            }

            size_t bufferSize = 0;
            metaEditor.QueryMetaDataSize(&bufferSize, internalEntryArray.data(), internalEntryArray.size());

            array<unsigned char>^ buf = gcnew array<unsigned char>(bufferSize);
            {
                pin_ptr<unsigned char> ptr = &buf[0];
                metaEditor.ConstructMetaData(ptr, bufferSize, internalEntryArray.data(), internalEntryArray.size());
                ptr = nullptr;
            }

            return Util::ReturnAndDeclareAlive(this, buf);
        }
    };
}}}
