﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>
#include <nn/fssystem/fs_NcaFileSystemDriver.h>
#include "IFileSystemArchiveReader.h"
#include "IndirectStorageStream.h"
#include "IStorageArchiveReader.h"
#include "StorageArchiveReaderImplBase.h"

namespace nn { namespace fssystem { namespace utilTool {
    class NcaSparseStorage;
}}}

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;
using namespace nn::fssystem;

    public ref class NintendoContentArchivePatchInfo
    {
    public:
        Int64 indirectOffset;
        Int64 indirectSize;
        array<Byte>^ indirectHeader;
        Int64 aesCtrExOffset;
        Int64 aesCtrExSize;
        array<Byte>^ aesCtrExHeader;
        array<Byte>^ masterHash; // TODO
        array<Byte>^ fsHeaderRawData; // TODO
    };

    public ref class NintendoContentArchiveFsHeaderInfo
    {
    public:
        Int32 GetFsIndex();
        UInt16 GetVersion();
        String^ GetFormatType();
        String^ GetFormatTypeWithPatch();
        byte GetHashType();
        byte GetEncryptionType();
        NintendoContentArchivePatchInfo^ GetPatchInfo();
        UInt32 GetSecureValue();
        UInt32 GetGeneration();
        array<byte>^ GetRawData(); // TODO
        array<byte>^ GetMasterHash(); // TODO
        UInt64 GetHashTargetOffset();
        Boolean ExistsSparseLayer();
        UInt32 GetSparseGeneration();

        NintendoContentArchiveFsHeaderInfo();
        ~NintendoContentArchiveFsHeaderInfo();
        !NintendoContentArchiveFsHeaderInfo();

    public:
        static String^ ConvertFsTypeToFormatType(Byte fsType, bool isPatchable);

    internal:
        NintendoContentArchiveFsHeaderInfo(std::unique_ptr<NcaFsHeaderReader> fsHeaderReader, UInt32 generation);
        NcaFsHeaderReader* GetFsHeaderReader(); // TODO: リファクタリング時に削除

    private:
        UInt16 m_Version;
        byte m_FsType;
        byte m_HashType;
        byte m_EncryptionType;
        UInt32 m_SecureValue;
        UInt32 m_Generation;
        NcaFsHeaderReader* m_pFsHeaderReader;
    };

    public ref class NintendoContentArchiveKeyType
    {
    public:
        static initonly Int32 KeyAreaEncryptionKey0     = GetKeyTypeValue(0, 0);
        static initonly Int32 KeyAreaEncryptionKey1     = GetKeyTypeValue(1, 0);
        static initonly Int32 KeyAreaEncryptionKey2     = GetKeyTypeValue(2, 0);
        static initonly Int32 KeyAreaEncryptionKey0Gen2 = GetKeyTypeValue(0, 2);
        static initonly Int32 KeyAreaEncryptionKey1Gen2 = GetKeyTypeValue(1, 2);
        static initonly Int32 KeyAreaEncryptionKey2Gen2 = GetKeyTypeValue(2, 2);
        static initonly Int32 KeyAreaEncryptionKey0Gen3 = GetKeyTypeValue(0, 3);
        static initonly Int32 KeyAreaEncryptionKey1Gen3 = GetKeyTypeValue(1, 3);
        static initonly Int32 KeyAreaEncryptionKey2Gen3 = GetKeyTypeValue(2, 3);
        static initonly Int32 KeyAreaEncryptionKey0Gen4 = GetKeyTypeValue(0, 4);
        static initonly Int32 KeyAreaEncryptionKey1Gen4 = GetKeyTypeValue(1, 4);
        static initonly Int32 KeyAreaEncryptionKey2Gen4 = GetKeyTypeValue(2, 4);
        static initonly Int32 KeyAreaEncryptionKey0Gen5 = GetKeyTypeValue(0, 5);
        static initonly Int32 KeyAreaEncryptionKey1Gen5 = GetKeyTypeValue(1, 5);
        static initonly Int32 KeyAreaEncryptionKey2Gen5 = GetKeyTypeValue(2, 5);
        static initonly Int32 HeaderEncryptionKey = (Int32)KeyType::NcaHeaderKey;
    };

    public interface class IKeyGenerator
    {
    public:
        array<Byte>^ Generate(array<Byte>^ encryptedKey, Int32 keyType);
        bool GetUseDevHsm();
    };

    class NintendoContentArchiveReaderImpl;

    class NintendoContentArchiveStorageReaderImpl;
    public ref class NintendoContentArchiveStorageReader : IStorageArchiveReader
    {
    public:
        ~NintendoContentArchiveStorageReader();
        !NintendoContentArchiveStorageReader();

        virtual array<Byte>^ Read(Int64 offset, Int32 size);
        virtual Int64 GetSize();

        List<IndirectStorageStream::ExcludeRange>^
            CollectExcludeRange(List<IndirectStorageStream::ExcludeRange>^ ranges);

    internal:
        NintendoContentArchiveStorageReader(std::shared_ptr<fs::IStorage> storage, const NcaFileSystemDriver::StorageOption& option);

    protected:
        NintendoContentArchiveStorageReaderImpl* m_Impl;
    };

    public ref class NintendoContentArchiveReader
    {
    public:
        value class StoragePair
        {
        public:
            IStorageArchiveReader^ data;
            IStorageArchiveReader^ table;
        };

    public:
        NintendoContentArchiveReader(Stream^ stream, IKeyGenerator^ keyGenerator);

        ~NintendoContentArchiveReader();
        !NintendoContentArchiveReader();

        List<Tuple<Int32, Int64>^>^ ListFsInfo();
        List<Tuple<Int32, Int64>^>^ ListFsInfo(NintendoContentArchiveReader^ originalReader);

        byte GetDistributionType();
        byte GetContentType();
        byte GetKeyGeneration();
        byte GetKeyIndex();
        UInt64 GetProgramId();
        array<byte>^ GetRightsId();
        UInt32 GetContentIndex();
        UInt32 GetSdkAddonVersion();
        bool HasFsInfo(int index);
        List<Int32>^ GetExistentFsIndices();
        Int64 GetFsStartOffset(int index);
        Int64 GetFsEndOffset(int index);
        UInt32 GetAesCtrGeneration();
        bool IsHardwareEncryptionKeyEmbedded();
        void SetExternalKey(array<byte>^ externalKey);
        bool HasValidInternalKey();
        array<Byte>^ GetInternalKey(int index);
        bool HasSparseStorageArchive();
        NintendoContentArchiveFsHeaderInfo^ GetFsHeaderInfo(int index);
        byte GetRepresentProgramIdOffset();
        byte GetHeaderEncryptionType();

        IFileSystemArchiveReader^ OpenFileSystemArchiveReader(int index);
        IFileSystemArchiveReader^ OpenFileSystemArchiveReader(int index, NintendoContentArchiveFsHeaderInfo^% fsInfo);
        IFileSystemArchiveReader^ OpenFileSystemArchiveReader(int index, NintendoContentArchiveReader^ originalReader);
        IFileSystemArchiveReader^ OpenFileSystemArchiveReader(int index, NintendoContentArchiveFsHeaderInfo^% fsInfo, NintendoContentArchiveReader^ originalReader);

        IStorageArchiveReader^ OpenFsRawStorageArchiveReader(int index);
        IStorageArchiveReader^ OpenFsDataStorageArchiveReader(int index);
        IStorageArchiveReader^ OpenFsDataStorageArchiveReader(NintendoContentArchiveFsHeaderInfo^ fsInfo);
        StoragePair OpenFsDataAndTableStorageArchiveReader(NintendoContentArchiveFsHeaderInfo^ fsInfo);

        void Verify();
        void Verify(NintendoContentArchiveReader^ previous);

    internal:
        NintendoContentArchiveReader(std::shared_ptr<fs::IStorage> storage, IKeyGenerator^ keyGenrator);
        std::shared_ptr<NcaReader> GetImpl();
        MemoryResource* GetAllocator();

        void SetExternalSparseStorage(std::shared_ptr<utilTool::NcaSparseStorage> pStorage);
        std::shared_ptr<utilTool::NcaSparseStorage> GetExternalSparseStorage();

        void OpenFsDataStorage(std::shared_ptr<fs::IStorage>* outStorage, NcaFileSystemDriver::StorageOption* pOption);

    private:
        [UnmanagedFunctionPointer(CallingConvention::Cdecl)]
        delegate void GenerateKeyDelegate(void* pOutKey, size_t outKeySize, const void* pEncryptedKey, size_t encryptedKeySize, int keyTypeValue, const fssystem::NcaCryptoConfiguration& cryptoConfiguration);

        void GenerateKey(void* pOutKey, size_t outKeySize, const void* pEncryptedKey, size_t encryptedKeySize, int keyTypeValue, const fssystem::NcaCryptoConfiguration& cryptoConfiguration);

        NintendoContentArchiveReaderImpl* m_Impl;

        IKeyGenerator^ m_keyGenerator;
        GenerateKeyDelegate^ m_GenerateKeyDelegate;
        IntPtr m_GenerateKeyFunc;
    };

}}}
