﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>
#include "IndirectStorageStreamUtil.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;

class IndirectStorageStreamImpl;

public ref class IndirectStorageStream
{
public:
    literal Int32 RegionSizeMin = (Int32)nn::fssystem::utilTool::BinaryMatch::RegionSizeMin;

    value class ExcludeRange
    {
    public:
        Int64 offset;
        Int64 size;
    };

    [System::Runtime::InteropServices::StructLayoutAttribute(System::Runtime::InteropServices::LayoutKind::Sequential)]
    value class BinaryMatchHint
    {
    public:
        Int64 oldOffset;
        Int64 oldSize;
        Int64 newOffset;
        Int64 newSize;
    };

public:
    IndirectStorageStream(IReadOnlySource^ oldSource, IReadOnlySource^ newSource, array<BinaryMatchHint>^ binaryMatchHints);
    ~IndirectStorageStream();
    !IndirectStorageStream();

    void SetExcludeRangeForOldSource(array<ExcludeRange>^ ranges);
    void SetExcludeRangeForNewSource(array<ExcludeRange>^ ranges);
    void SetBinaryRegionInfo(String^ originalPath, String^ outputPath, array<Byte>^ rawHeader);
    void Build(UInt32 shiftSize, UInt32 blockSize, UInt32 regionSize, Int64 matchSize, Int64 windowSize, bool willUseCache);
    void WriteIndirectTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    void WriteAesCtrExTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    array<Byte>^ ReadData(Int64 offset, Int32 size);
    void OutputBuildLog(Stream^ tableStream, Stream^ fragmentStream, Int64 startOffset);
    IndirectStorageProgress GetProgress();
    Int64 GetDataSize();
    Int32 GetIndirectHeaderSize();
    Int32 GetIndirectTableSize();
    Int32 GetAesCtrExHeaderSize();
    Int32 GetAesCtrExTableSize();

private:
    IndirectStorageStreamImpl* m_pImpl;
    array<BinaryMatchHint>^ m_BinaryMatchHints;
};

class IndirectStorageDifferenceStreamImpl;

public ref class IndirectStorageDifferenceStream
{
public:
    IndirectStorageDifferenceStream(IReadOnlySource^ oldSource, IReadOnlySource^ newSource);
    ~IndirectStorageDifferenceStream();
    !IndirectStorageDifferenceStream();

    void SetExcludeRangeForOldSource(array<IndirectStorageStream::ExcludeRange>^ ranges);
    void SetExcludeRangeForNewSource(array<IndirectStorageStream::ExcludeRange>^ ranges);
    void Build(UInt32 shiftSize, UInt32 blockSize, UInt32 regionSize, Int64 matchSize, Int64 windowSize);
    void Import(UInt32 blockSize, array<Byte>^ headerData, array<Byte>^ tableData, Stream^ differenceStream);
    void WriteIndirectTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    array<Byte>^ ReadData(Int64 offset, Int32 size);
    void OutputBuildLog(Stream^ tableStream, Stream^ fragmentStream, Int64 startOffset);
    IndirectStorageProgress GetProgress();
    Int64 GetDataSize();
    Int32 GetIndirectHeaderSize();
    Int32 GetIndirectTableSize();

private:
    IndirectStorageDifferenceStreamImpl* m_pImpl;
};

}}}
