﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>
#include <nn/fssystem/fs_BucketTree.h>

#include "IStorageArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;

using namespace nn;

    private class IndirectStorageArchiveUtils
    {
    public:
        static void ReadHeader(fssystem::BucketTree::Header* outValue, fs::IStorage* headerStorage);
    };

    public enum class IndirectStorageIndex
    {
        // TORIAEZU
        Original = 0,
        Patch = 1,
    };

    public ref class IndirectStorageEntry
    {
    public:
        Int64 offset;
        Int64 size;
        IndirectStorageIndex index;

        IndirectStorageEntry(Int64 offset, Int64 size, Int32 index)
        {
            this->offset = offset;
            this->size = size;
            this->index = (IndirectStorageIndex)index;
        }
    };

    class IndirectStorageArchiveReaderImpl;
    ref class NintendoContentArchiveReader;
    public ref class IndirectStorageArchiveReader : IStorageArchiveReader
    {
    public:
        IndirectStorageArchiveReader(array<Byte>^ headerData, array<Byte>^ tableData, Stream^ oldStream, Stream^ differenceStream);
        IndirectStorageArchiveReader(NintendoContentArchiveReader^ originalNcaReader, NintendoContentArchiveReader^ patchNcaReader, int fsIndex);

        ~IndirectStorageArchiveReader();
        !IndirectStorageArchiveReader();

        virtual array<Byte>^ Read(Int64 offset, Int32 size);
        virtual int64_t GetSize();

        List<IndirectStorageEntry^>^ GetFragmentListOnDifference(Int64 offset, Int64 size);

    private:
        IndirectStorageArchiveReaderImpl* m_Impl;
    };

}}}
