﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "BufferManager.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

    namespace
    {
        nn::fssystem::FileSystemBufferManager* s_pBufferManager = nullptr;
        const int CachePageCount = 1024;
        const int CachePageSize = 1024 * 16;
        const int CacheSize = 8 * 1024 * 1024;
        unsigned char s_CacheBuffer[CacheSize];
    }

    nn::fssystem::FileSystemBufferManager* GetBufferManager()
    {
        if (!s_pBufferManager)
        {
            s_pBufferManager = new nn::fssystem::FileSystemBufferManager();
            s_pBufferManager->Initialize(CachePageCount, reinterpret_cast<uintptr_t>(s_CacheBuffer), sizeof(s_CacheBuffer), CachePageSize);
        }
        return s_pBufferManager;
    }
}}}
