﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ISigner.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

    public ref class Rsa2048PssSha256SignCryptoDriver : ISigner
    {
    public:
        static const int KeySize = 256;

        Rsa2048PssSha256SignCryptoDriver(array<Byte>^ modulus, array<Byte>^ publicExponent, array<Byte>^ privateExponent);
        Rsa2048PssSha256SignCryptoDriver(Rsa2048PssSha256KeyIndex keyIndex);

        ~Rsa2048PssSha256SignCryptoDriver();
        !Rsa2048PssSha256SignCryptoDriver();

        virtual array<Byte>^ SignBlock(array<Byte>^ src, int srcOffset, int srcSize);
        virtual bool VerifyBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ signature);
        virtual array<Byte>^ GetKeyModulus();
        virtual array<Byte>^ GetKeyPublicExponent();

    private:
        System::Security::Cryptography::RNGCryptoServiceProvider m_Rng;

        array<Byte>^ m_KeyModulus;
        array<Byte>^ m_KeyPublicExponent;
        array<Byte>^ m_KeyPrivateExponent;

        // 開発用 NCA ヘッダ 1 署名鍵
        static array<Byte>^ NcaHeader1SignKeyPrivateExponent =
        {
            0x0c, 0x05, 0xb5, 0x6d, 0xe9, 0x0f, 0xe6, 0x41, 0x55, 0x6d, 0x52, 0x36, 0xc8, 0x57, 0xb3, 0x60,
            0x57, 0xdb, 0xcd, 0xb3, 0x03, 0x0f, 0x57, 0xf1, 0x17, 0x8a, 0x30, 0x33, 0x8a, 0x68, 0x92, 0xfb,
            0x73, 0x57, 0x04, 0x8a, 0xcb, 0xe3, 0xf4, 0x8a, 0xbf, 0xe3, 0xf2, 0xac, 0x38, 0x23, 0x30, 0x26,
            0x95, 0x42, 0x3d, 0x50, 0xfa, 0xb4, 0xaf, 0x60, 0x21, 0x75, 0xdc, 0xd9, 0x57, 0xb4, 0xc3, 0x6c,
            0xe5, 0xf6, 0xe5, 0xe0, 0x55, 0x65, 0x77, 0x4b, 0xc7, 0xa6, 0x7e, 0x0a, 0xfe, 0xdd, 0x80, 0x42,
            0x4f, 0x0d, 0x7e, 0x15, 0x8d, 0xf4, 0x27, 0x37, 0x24, 0x99, 0xf2, 0x12, 0x31, 0xdb, 0xd7, 0x7f,
            0x1e, 0x92, 0x21, 0x14, 0xca, 0x21, 0xf6, 0x50, 0x08, 0x92, 0xae, 0x31, 0xde, 0xf4, 0x29, 0x24,
            0xd6, 0x41, 0xb3, 0x47, 0x18, 0x37, 0x14, 0xf9, 0x8d, 0x5d, 0x95, 0xf4, 0xf5, 0x7f, 0x99, 0xfb,
            0x86, 0xda, 0x65, 0xe9, 0x72, 0xa9, 0x77, 0x65, 0xc8, 0xc5, 0x29, 0x5a, 0x19, 0x2b, 0x51, 0x1c,
            0x72, 0xeb, 0x49, 0xd1, 0x0b, 0x73, 0x8b, 0x3e, 0x2e, 0xc8, 0x7e, 0xff, 0xd8, 0xfe, 0xf4, 0xf4,
            0xf6, 0x92, 0x27, 0x7f, 0xa0, 0xdb, 0xc1, 0x25, 0xbc, 0xec, 0x5f, 0x0b, 0x2d, 0x99, 0xeb, 0xdd,
            0x9e, 0x5d, 0x42, 0x75, 0xb5, 0xe3, 0x24, 0xcb, 0xe9, 0xeb, 0xd9, 0x00, 0x4b, 0x12, 0x5d, 0xa3,
            0xa6, 0x25, 0xac, 0x20, 0x82, 0x25, 0x53, 0x1f, 0xc6, 0x2f, 0x27, 0xf1, 0x99, 0x7a, 0x99, 0xdc,
            0xa5, 0xc0, 0x5e, 0x63, 0x0f, 0x78, 0x03, 0x2a, 0x18, 0xd9, 0xe1, 0x06, 0x3b, 0xdf, 0xb2, 0x95,
            0x19, 0x32, 0xb4, 0x65, 0xd2, 0xd0, 0xfe, 0x18, 0xc7, 0x54, 0x5c, 0xa4, 0xf6, 0xd8, 0xfd, 0xdb,
            0x6d, 0xd8, 0xda, 0xf2, 0x9a, 0x55, 0x5c, 0x3e, 0xec, 0x17, 0x72, 0x09, 0xa3, 0x1a, 0x0a, 0xc1
        };

        static array<Byte>^ NcaHeader1SignKeyPublicExponent =
        {
            0x01, 0x00, 0x01
        };

        static array<Byte>^ NcaHeader1SignKeyModulus =
        {
            0xd8, 0xf1, 0x18, 0xef, 0x32, 0x72, 0x4c, 0xa7, 0x47, 0x4c, 0xb9, 0xea, 0xb3, 0x04, 0xa8, 0xa4,
            0xac, 0x99, 0x08, 0x08, 0x04, 0xbf, 0x68, 0x57, 0xb8, 0x43, 0x94, 0x2b, 0xc7, 0xb9, 0x66, 0x49,
            0x85, 0xe5, 0x8a, 0x9b, 0xc1, 0x00, 0x9a, 0x6a, 0x8d, 0xd0, 0xef, 0xce, 0xff, 0x86, 0xc8, 0x5c,
            0x5d, 0xe9, 0x53, 0x7b, 0x19, 0x2a, 0xa8, 0xc0, 0x22, 0xd1, 0xf3, 0x22, 0x0a, 0x50, 0xf2, 0x2b,
            0x65, 0x05, 0x1b, 0x9e, 0xec, 0x61, 0xb5, 0x63, 0xa3, 0x6f, 0x3b, 0xba, 0x63, 0x3a, 0x53, 0xf4,
            0x49, 0x2f, 0xcf, 0x03, 0xcc, 0xd7, 0x50, 0x82, 0x1b, 0x29, 0x4f, 0x08, 0xde, 0x1b, 0x6d, 0x47,
            0x4f, 0xa8, 0xb6, 0x6a, 0x26, 0xa0, 0x83, 0x3f, 0x1a, 0xaf, 0x83, 0x8f, 0x0e, 0x17, 0x3f, 0xfe,
            0x44, 0x1c, 0x56, 0x94, 0x2e, 0x49, 0x83, 0x83, 0x03, 0xe9, 0xb6, 0xad, 0xd5, 0xde, 0xe3, 0x2d,
            0xa1, 0xd9, 0x66, 0x20, 0x5d, 0x1f, 0x5e, 0x96, 0x5d, 0x5b, 0x55, 0x0d, 0xd4, 0xb4, 0x77, 0x6e,
            0xae, 0x1b, 0x69, 0xf3, 0xa6, 0x61, 0x0e, 0x51, 0x62, 0x39, 0x28, 0x63, 0x75, 0x76, 0xbf, 0xb0,
            0xd2, 0x22, 0xef, 0x98, 0x25, 0x02, 0x05, 0xc0, 0xd7, 0x6a, 0x06, 0x2c, 0xa5, 0xd8, 0x5a, 0x9d,
            0x7a, 0xa4, 0x21, 0x55, 0x9f, 0xf9, 0x3e, 0xbf, 0x16, 0xf6, 0x07, 0xc2, 0xb9, 0x6e, 0x87, 0x9e,
            0xb5, 0x1c, 0xbe, 0x97, 0xfa, 0x82, 0x7e, 0xed, 0x30, 0xd4, 0x66, 0x3f, 0xde, 0xd8, 0x1b, 0x4b,
            0x15, 0xd9, 0xfb, 0x2f, 0x50, 0xf0, 0x9d, 0x1d, 0x52, 0x4c, 0x1c, 0x4d, 0x8d, 0xae, 0x85, 0x1e,
            0xea, 0x7f, 0x86, 0xf3, 0x0b, 0x7b, 0x87, 0x81, 0x98, 0x23, 0x80, 0x63, 0x4f, 0x2f, 0xb0, 0x62,
            0xcc, 0x6e, 0xd2, 0x46, 0x13, 0x65, 0x2b, 0xd6, 0x44, 0x33, 0x59, 0xb5, 0x8f, 0xb9, 0x4a, 0xa9
        };

        // 開発用 Nrr/Nrr 証明書署名鍵
        static array<Byte>^ NrrCertificateSignKeyPrivateExponent =
        {
            0x2c, 0x5e, 0x97, 0x84, 0x97, 0x13, 0x8c, 0xd7, 0xfc, 0x6f, 0x36, 0xc1, 0xc1, 0x2a, 0x87, 0x4b,
            0xe0, 0x86, 0xd2, 0xfa, 0xb8, 0x97, 0x77, 0xcf, 0xbb, 0xe8, 0x89, 0x58, 0x28, 0xd9, 0xc0, 0xd8,
            0x81, 0x7e, 0x1e, 0x67, 0x16, 0x95, 0xcf, 0x14, 0x24, 0x82, 0xb4, 0xe7, 0x92, 0x08, 0xb4, 0xa7,
            0x88, 0xc7, 0xc6, 0x8e, 0x32, 0x1c, 0xe4, 0xbb, 0x39, 0x03, 0xa2, 0xde, 0x21, 0x9d, 0xb8, 0xa1,
            0x69, 0x36, 0x36, 0x9d, 0x11, 0x24, 0xcd, 0xb1, 0x48, 0x6b, 0xd3, 0x4b, 0x4f, 0x9e, 0x38, 0x91,
            0xd8, 0xfa, 0xdc, 0x00, 0x67, 0x11, 0xe4, 0xba, 0x54, 0xc7, 0x47, 0x54, 0xfb, 0x55, 0x2a, 0x41,
            0xad, 0x4f, 0x9f, 0x6d, 0x03, 0xf5, 0xec, 0x4b, 0x42, 0x78, 0xe2, 0xcd, 0x6e, 0x04, 0xfb, 0x5d,
            0x20, 0x94, 0x52, 0xaa, 0xfd, 0x58, 0x3a, 0x85, 0x58, 0x31, 0xae, 0xde, 0x16, 0xbe, 0x42, 0x22,
            0x85, 0xa1, 0x42, 0xbd, 0xbb, 0xa0, 0x87, 0xeb, 0x3b, 0x25, 0x0f, 0x15, 0x5a, 0xa1, 0x0f, 0x53,
            0x0e, 0x51, 0xf5, 0xf0, 0xdb, 0x8e, 0xcc, 0x82, 0x4a, 0x4e, 0x67, 0x5d, 0xc1, 0x4c, 0x62, 0x1a,
            0x1d, 0x5e, 0x4a, 0xc4, 0xf3, 0x1d, 0xe6, 0x89, 0x83, 0xcb, 0x00, 0xd0, 0x26, 0xfb, 0x62, 0xf1,
            0xd9, 0xc6, 0x18, 0x68, 0x16, 0xf6, 0x35, 0xee, 0x74, 0xe8, 0xea, 0xd1, 0xce, 0x8a, 0xe1, 0x83,
            0xda, 0xe0, 0x30, 0x5f, 0x84, 0x43, 0x0d, 0x10, 0xab, 0x04, 0x5f, 0x0e, 0xdd, 0x9b, 0xee, 0x17,
            0x73, 0x86, 0x70, 0x32, 0x9a, 0x96, 0xab, 0x09, 0x54, 0xa7, 0x30, 0x25, 0x41, 0x94, 0xe1, 0x5f,
            0x03, 0x4f, 0xea, 0xba, 0x7d, 0x2b, 0x9a, 0x41, 0x1c, 0x50, 0x5f, 0x2b, 0xdd, 0x83, 0xfa, 0xf4,
            0xef, 0x57, 0x50, 0xd2, 0x7e, 0xb4, 0x9f, 0x89, 0x84, 0x52, 0x37, 0x63, 0x82, 0x02, 0x69, 0x51
        };

        static array<Byte>^ NrrCertificateSignKeyPublicExponent =
        {
            0x01, 0x00, 0x01
        };

        static array<Byte>^ NrrCertificateSignKeyModulus =
        {
            0xc1, 0x15, 0x7c, 0x02, 0x26, 0xe5, 0x35, 0x6f, 0x99, 0xdb, 0xbe, 0xbd, 0xd7, 0x01, 0x07, 0x1c,
            0xc2, 0x3d, 0x1e, 0x6b, 0x7e, 0x08, 0x07, 0xbc, 0xe2, 0x6d, 0x49, 0xec, 0x0b, 0xff, 0xe4, 0x91,
            0x8c, 0x62, 0xb9, 0xfc, 0x69, 0xbf, 0x3a, 0xb6, 0x6c, 0x3a, 0x5d, 0x0e, 0x31, 0x5e, 0x6c, 0x1d,
            0x9a, 0x21, 0xd9, 0x9d, 0xd3, 0xb8, 0x50, 0x5f, 0x27, 0x7c, 0x4a, 0xd2, 0xfe, 0xe8, 0xda, 0x1c,
            0xb9, 0x9e, 0x7e, 0x1e, 0x2f, 0x7d, 0xf9, 0x70, 0xa2, 0x98, 0x19, 0x6a, 0x53, 0x40, 0x64, 0xe7,
            0xc0, 0x92, 0xae, 0x64, 0xd2, 0x01, 0xb2, 0x49, 0x30, 0x19, 0x7f, 0xf8, 0x6e, 0x0d, 0x49, 0x35,
            0xe9, 0x95, 0x77, 0x00, 0x65, 0xc5, 0x1e, 0xf5, 0x2a, 0xf9, 0xa1, 0x52, 0xa0, 0xa4, 0xfa, 0x87,
            0x3d, 0x8f, 0x51, 0xec, 0x02, 0x80, 0xa4, 0xc7, 0x22, 0x74, 0xef, 0x56, 0x61, 0x71, 0x39, 0xe2,
            0x2f, 0x03, 0x82, 0xdb, 0x50, 0xe9, 0xcc, 0x60, 0x48, 0x46, 0x71, 0xe2, 0xc6, 0x71, 0xf3, 0xf9,
            0x85, 0x52, 0x1a, 0xe2, 0xa8, 0x18, 0x77, 0x86, 0xd0, 0x12, 0xeb, 0x4f, 0x81, 0xa0, 0xdf, 0x20,
            0x42, 0xf0, 0xf8, 0xe3, 0x00, 0xe6, 0xfc, 0xa7, 0x44, 0xf0, 0xdc, 0x2b, 0x5b, 0xa0, 0xd3, 0x01,
            0x34, 0xd0, 0xd7, 0xfd, 0xef, 0x66, 0x92, 0xb3, 0x87, 0x64, 0xd9, 0x76, 0xda, 0x6e, 0x3a, 0x19,
            0x98, 0x1f, 0xbd, 0x1f, 0x25, 0x69, 0x9f, 0x28, 0xe6, 0x9e, 0xb7, 0x38, 0x92, 0x12, 0x16, 0xde,
            0xda, 0xe2, 0xb9, 0x7e, 0xfa, 0x98, 0x94, 0xf4, 0x9a, 0xdf, 0x2d, 0xc0, 0x99, 0x83, 0x61, 0xad,
            0xb8, 0x3e, 0x27, 0x3f, 0x0e, 0xb8, 0x9e, 0x9b, 0x11, 0x78, 0xf1, 0x06, 0x30, 0x5b, 0xca, 0xf4,
            0xeb, 0x72, 0x20, 0xd3, 0x15, 0x15, 0xc0, 0xc7, 0x1a, 0x08, 0xae, 0x6e, 0xb2, 0x02, 0x43, 0xe9
        };

        // 開発用 ACID 検証鍵
        static array<Byte>^ AcidSignKeyPublicExponent =
        {
            0x01, 0x00, 0x01
        };

        static array<Byte>^ AcidSignKeyModulus =
        {
            0xd6, 0x34, 0xa5, 0x78, 0x6c, 0x68, 0xce, 0x5a, 0xc2, 0x37, 0x17, 0xf3, 0x82, 0x45, 0xc6, 0x89,
            0xe1, 0x2d, 0x06, 0x67, 0xbf, 0xb4, 0x06, 0x19, 0x55, 0x6b, 0x27, 0x66, 0x0c, 0xa4, 0xb5, 0x87,
            0x81, 0x25, 0xf4, 0x30, 0xbc, 0x53, 0x08, 0x68, 0xa2, 0x48, 0x49, 0x8c, 0x3f, 0x38, 0x40, 0x9c,
            0xc4, 0x26, 0xf4, 0x79, 0xe2, 0xa1, 0x85, 0xf5, 0x5c, 0x7f, 0x58, 0xba, 0xa6, 0x1c, 0xa0, 0x8b,
            0x84, 0x16, 0x14, 0x6f, 0x85, 0xd9, 0x7c, 0xe1, 0x3c, 0x67, 0x22, 0x1e, 0xfb, 0xd8, 0xa7, 0xa5,
            0x9a, 0xbf, 0xec, 0x0e, 0xcf, 0x96, 0x7e, 0x85, 0xc2, 0x1d, 0x49, 0x5d, 0x54, 0x26, 0xcb, 0x32,
            0x7c, 0xf6, 0xbb, 0x58, 0x03, 0x80, 0x2b, 0x5d, 0xf7, 0xfb, 0xd1, 0x9d, 0xc7, 0xc6, 0x2e, 0x53,
            0xc0, 0x6f, 0x39, 0x2c, 0x1f, 0xa9, 0x92, 0xf2, 0x4d, 0x7d, 0x4e, 0x74, 0xff, 0xe4, 0xef, 0xe4,
            0x7c, 0x3d, 0x34, 0x2a, 0x71, 0xa4, 0x97, 0x59, 0xff, 0x4f, 0xa2, 0xf4, 0x66, 0x78, 0xd8, 0xba,
            0x99, 0xe3, 0xe6, 0xdb, 0x54, 0xb9, 0xe9, 0x54, 0xa1, 0x70, 0xfc, 0x05, 0x1f, 0x11, 0x67, 0x4b,
            0x26, 0x8c, 0x0c, 0x3e, 0x03, 0xd2, 0xa3, 0x55, 0x5c, 0x7d, 0xc0, 0x5d, 0x9d, 0xff, 0x13, 0x2f,
            0xfd, 0x19, 0xbf, 0xed, 0x44, 0xc3, 0x8c, 0xa7, 0x28, 0xcb, 0xe5, 0xe0, 0xb1, 0xa7, 0x9c, 0x33,
            0x8d, 0xb8, 0x6e, 0xde, 0x87, 0x18, 0x22, 0x60, 0xc4, 0xae, 0xf2, 0x87, 0x9f, 0xce, 0x09, 0x5c,
            0xb5, 0x99, 0xa5, 0x9f, 0x49, 0xf2, 0xd7, 0x58, 0xfa, 0xf9, 0xc0, 0x25, 0x7d, 0xd6, 0xcb, 0xf3,
            0xd8, 0x6c, 0xa2, 0x69, 0x91, 0x68, 0x73, 0xb1, 0x94, 0x6f, 0xa3, 0xf3, 0xb9, 0x7d, 0xf8, 0xe0,
            0x72, 0x9e, 0x93, 0x7b, 0x7a, 0xa2, 0x57, 0x60, 0xb7, 0x5b, 0xa9, 0x84, 0xae, 0x64, 0x88, 0x69
        };
    };

}}}
