﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public enum class Aes128KeyIndex : uint8_t
    {
        NcaContentKey,
        NcaHeader,
        XciInitialData,
        XciHeader,
        ETicketCommonKey,
    };

    public enum class Rsa2048OaepSha256KeyIndex : uint8_t
    {
        XcieKeyArea,
        XcirKeyArea
    };

    public interface class IEncryptor
    {
    public:
        property int KeySize
        {
            int get();
        }
        void EncryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset);
        void DecryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset);
    };

    public interface class IIvBasedEncryptor
    {
    public:
        property int KeySize
        {
            int get();
        }
        void EncryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset);
        void DecryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset);
    };

    public interface class IEncryptorWithMac
    {
    public:
        property int KeySize
        {
            int get();
        }
        void EncryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset);
        void DecryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset);
    };

    public interface class IXtsModeEncryptor : IIvBasedEncryptor
    {
    };

    public interface class ICtrModeEncryptor : IIvBasedEncryptor
    {
    };

    public interface class ICbcModeEncryptor : IIvBasedEncryptor
    {
    };

    public interface class ICcmModeEncryptor : IEncryptorWithMac
    {
    };

}}}
