﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HsmInterfaceManager.h"
#include "ISigner.h"
#include "Rsa2048PssSha256SignCryptoDriver.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public ref class HsmRsa2048PssSha256SignCryptoDriver : ISigner
    {
    public:
        static const int KeySize = 256;

        HsmRsa2048PssSha256SignCryptoDriver(Rsa2048PssSha256KeyIndex keyIndex)
        {
            m_HsmInterface = gcnew HsmInterface();
            m_HsmKeyIndex = keyIndex;
            GC::KeepAlive(this);
        }

        ~HsmRsa2048PssSha256SignCryptoDriver()
        {
            this->!HsmRsa2048PssSha256SignCryptoDriver();
        }

        !HsmRsa2048PssSha256SignCryptoDriver()
        {
        }

        virtual array<Byte>^ SignBlock(array<Byte>^ src, int srcOffset, int srcSize)
        {
            // W/A : 開発鍵動作時に一部の鍵は内部で持ったものを使う
            if (m_HsmInterface->GetUseDev() && m_HsmKeyIndex != Rsa2048PssSha256KeyIndex::Acid)
            {
                auto cryptor = gcnew Rsa2048PssSha256SignCryptoDriver(m_HsmKeyIndex);
                return cryptor->SignBlock(src, srcOffset, srcSize);
            }

            array<unsigned char>^ dst = gcnew array<unsigned char>(KeySize);
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinDst = &dst[0];

            m_HsmInterface->SignRsa2048PssSha256(m_HsmKeyIndex, pinDst, KeySize, pinSrc, srcSize);

            pinSrc = nullptr;
            pinDst = nullptr;

            GC::KeepAlive(this);
            return dst;
        }

        virtual bool VerifyBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ signature)
        {
            // W/A : 開発鍵動作時に一部の鍵は内部で持ったものを使う
            if (m_HsmInterface->GetUseDev() && m_HsmKeyIndex != Rsa2048PssSha256KeyIndex::Acid)
            {
                auto cryptor = gcnew Rsa2048PssSha256SignCryptoDriver(m_HsmKeyIndex);
                return cryptor->VerifyBlock(src, srcOffset, srcSize, signature);
            }

            bool result;
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinSignature = &signature[0];

            result = m_HsmInterface->VerifyRsa2048PssSha256(m_HsmKeyIndex, pinSignature, KeySize, pinSrc, srcSize);

            pinSrc = nullptr;
            pinSignature = nullptr;

            GC::KeepAlive(this);
            return result;
        }

        virtual array<Byte>^ GetKeyModulus()
        {
            array<unsigned char>^ modulus = gcnew array<unsigned char>(KeySize);
            array<unsigned char>^ publicExponent = gcnew array<unsigned char>(3);
            pin_ptr<unsigned char> pinKeyModulus = &modulus[0];
            pin_ptr<unsigned char> pinKeyPublicExponent = &publicExponent[0];

            m_HsmInterface->GetRsa2048PssSha256PublicKey(m_HsmKeyIndex, pinKeyModulus, modulus->Length, pinKeyPublicExponent, publicExponent->Length);

            pinKeyModulus = nullptr;
            pinKeyPublicExponent = nullptr;

            GC::KeepAlive(this);
            return modulus;
        }

        virtual array<Byte>^ GetKeyPublicExponent()
        {
            array<unsigned char>^ modulus = gcnew array<unsigned char>(KeySize);
            array<unsigned char>^ publicExponent = gcnew array<unsigned char>(3);
            pin_ptr<unsigned char> pinKeyModulus = &modulus[0];
            pin_ptr<unsigned char> pinKeyPublicExponent = &publicExponent[0];

            m_HsmInterface->GetRsa2048PssSha256PublicKey(m_HsmKeyIndex, pinKeyModulus, modulus->Length, pinKeyPublicExponent, publicExponent->Length);

            pinKeyModulus = nullptr;
            pinKeyPublicExponent = nullptr;

            GC::KeepAlive(this);
            return publicExponent;
        }

    private:
        HsmInterface^ m_HsmInterface;
        Rsa2048PssSha256KeyIndex m_HsmKeyIndex;
    };

}}}
