﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Aes128CtrEncryptor.h>
#include <nn/crypto/crypto_Aes128CtrDecryptor.h>
#include "IEncryptor.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public ref class Aes128CtrCryptoDriver : ICtrModeEncryptor
    {
    public:
        property int KeySize
        {
            virtual int get() { return 16; }
        };

        Aes128CtrCryptoDriver(array<Byte>^ keyData)
        {
            if (keyData->Length != KeySize)
            {
                throw gcnew ArgumentException();
            }
            m_Key = gcnew array<Byte>(KeySize);
            System::Buffer::BlockCopy(keyData, 0, m_Key, 0, KeySize);
            GC::KeepAlive(this);
        }

        virtual void EncryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            {
                pin_ptr<unsigned char> pinKey = &m_Key[0];
                pin_ptr<unsigned char> pinSrc = &src[srcOffset];
                pin_ptr<unsigned char> pinIv = &iv[0];
                pin_ptr<unsigned char> pinDst = &dst[dstOffset];
                auto encryptedSize = nn::crypto::EncryptAes128Ctr(pinDst, srcSize, pinKey, KeySize, pinIv, KeySize, pinSrc, srcSize);
                pinKey = nullptr;
                pinSrc = nullptr;
                pinIv = nullptr;
                pinDst = nullptr;
                if (encryptedSize != srcSize)
                {
                    throw gcnew InvalidOperationException();
                }
            }
            GC::KeepAlive(this);
        }

        virtual void DecryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            EncryptBlock(iv, src, srcOffset, srcSize, dst, dstOffset);
            GC::KeepAlive(this);
        }

    private:
        array<Byte>^ m_Key;
    };

}}}
