﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Aes128CcmEncryptor.h>
#include <nn/crypto/crypto_Aes128CcmDecryptor.h>
#include "IEncryptor.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;
using namespace System::Security::Cryptography;

    public ref class Aes128CcmCryptoDriver : ICcmModeEncryptor
    {
    public:
        property int KeySize
        {
            virtual int get() { return 16; }
        };

        Aes128CcmCryptoDriver(array<Byte>^ key)
        {
            m_Key = key;
            GC::KeepAlive(this);
        }

        ~Aes128CcmCryptoDriver()
        {
            this->!Aes128CcmCryptoDriver();
        }

        !Aes128CcmCryptoDriver()
        {
        }

        virtual void EncryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinKey = &m_Key[0];
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];
            pin_ptr<unsigned char> pinDstMac = &dstMac[dstMacOffset];
            pin_ptr<unsigned char> pinNonce = &nonce[0];
            pin_ptr<unsigned char> pinAad = aad->Length != 0 ? &aad[0] : nullptr;
            auto encryptedSize = nn::crypto::EncryptAes128Ccm(pinDst, srcSize,
                                                              pinDstMac, macSize,
                                                              pinKey, KeySize,
                                                              pinNonce, nonce->Length,
                                                              pinSrc, srcSize,
                                                              pinAad, aad->Length,
                                                              macSize);
            pinKey = nullptr;
            pinSrc = nullptr;
            pinDst = nullptr;
            pinDstMac = nullptr;
            pinNonce = nullptr;
            pinAad = nullptr;
            if (encryptedSize != srcSize)
            {
                GC::KeepAlive(this);
                throw gcnew InvalidOperationException();
            }
        }

        virtual void DecryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinKey = &m_Key[0];
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];
            pin_ptr<unsigned char> pinDstMac = &dstMac[dstMacOffset];
            pin_ptr<unsigned char> pinNonce = &nonce[0];
            pin_ptr<unsigned char> pinAad = aad->Length != 0 ? &aad[0] : nullptr;
            auto encryptedSize = nn::crypto::DecryptAes128Ccm(pinDst, srcSize,
                                                              pinDstMac, macSize,
                                                              pinKey, KeySize,
                                                              pinNonce, nonce->Length,
                                                              pinSrc, srcSize,
                                                              pinAad, aad->Length,
                                                              macSize);
            pinKey = nullptr;
            pinSrc = nullptr;
            pinDst = nullptr;
            pinDstMac = nullptr;
            pinNonce = nullptr;
            pinAad = nullptr;
            if (encryptedSize != srcSize)
            {
                GC::KeepAlive(this);
                throw gcnew InvalidOperationException();
            }
        }

    private:
        array<Byte>^ m_Key;
    };

}}}
