﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public static class XmlUnknownElementHandler
    {
        public static void DeserializationHandler(object sender, XmlElementEventArgs args)
        {
            List<string> ignoreTagList = new List<string>();

            var baseObj = args.ObjectBeingDeserialized;
            var modelName = args.ObjectBeingDeserialized.ToString().Split('.').Last();

            if (modelName == "ApplicationControlPropertyModel")
            {
                string[] list = { "TouchScreenUsage" };
                ignoreTagList.AddRange(list);
            }

            if (ignoreTagList.ToList().Find(entry => entry == args.Element.LocalName) != null)
            {
                return;
            }

            var xmlAttributes = (XmlRootAttribute)Attribute.GetCustomAttribute(baseObj.GetType(), typeof(XmlRootAttribute));
            var rootName = xmlAttributes != null ? string.Format(" in <{0}>.", xmlAttributes.ElementName) : ".";
            throw new ArgumentException(string.Format("<{0}> is not supported{1}", args.Element.LocalName, rootName));
        }
    }
}
