﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.CryptoLibrary;
using Nintendo.Authoring.ETicketLibrary;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public class TicketCertificateSource : ISource
    {
        private ISource CertificateBufferSource;

        public TicketCertificateSource(bool isProdEncryption, KeyConfiguration keyConfiguration)
        {
            int certificateSize = Certificate.GetCertificateSize();
            Byte[] certificateBuffer = new Byte[certificateSize];

            if (isProdEncryption)
            {
                if (keyConfiguration.GetProdETicketSignKey() != null)
                {
                    // 正しく動作させるためには、署名鍵に対応する証明書を取得する必要があるので
                    // KeyConfig で署名鍵を指定した場合は、KeuConfig で対応する証明書も指定する必要があるが
                    // とりあえず適当な証明書を取得する
                    Certificate.GetCertificate(certificateBuffer, "devel-XS00000020");
                }
                else
                {
                    // 開発版 HSM サーバを使うかどうか
                    HsmInterface hsmInterfase = new HsmInterface();

                    if (hsmInterfase.GetUseDev())
                    {
                        // devel-XS00000021 を取得する
                        Certificate.GetCertificate(certificateBuffer, "devel-XS00000021");
                    }
                    else
                    {
                        // prod-XS00000020 を取得する
                        Certificate.GetCertificate(certificateBuffer, "prod-XS00000020");
                    }
                }
            }
            else
            {
                // devel-XS00000020 を取得する
                Certificate.GetCertificate(certificateBuffer, "devel-XS00000020");
            }

            CertificateBufferSource = new MemorySource(certificateBuffer, 0, certificateSize);
        }

        public long Size
        {
            get
            {
                return CertificateBufferSource.Size;
            }
        }

        public ByteData PullData(long offset, int size)
        {
            return CertificateBufferSource.PullData(offset, size);
        }

        public SourceStatus QueryStatus()
        {
            return CertificateBufferSource.QueryStatus();
        }
    }
}
