﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [XmlRoot("MiddlewareList", IsNullable = false)]
    public class MiddlewareList
    {
        [XmlElement("Middleware")]
        public List<MiddlewareModel> Entries { get; set; }

        static public MiddlewareList Create(ModuleInfo[] moduleInfos)
        {
            var model = new MiddlewareList();
            model.Entries = new List<MiddlewareModel>();
            foreach (var moduleInfo in moduleInfos)
            {
                var entry = new MiddlewareModel();
                entry.ModuleName = moduleInfo.ModuleName;
                entry.VenderName = moduleInfo.VenderName;
                entry.NsoName = moduleInfo.FileName;
                model.Entries.Add(entry);
            }
            return model;
        }
        static public MiddlewareList Create()
        {
            var model = new MiddlewareList();
            model.Entries = new List<MiddlewareModel>();
            return model;
        }
        public List<string> GetModuleNameList()
        {
            return Entries.Select(entry => { return entry.ModuleName; }).ToList();
        }
    }

    [XmlRoot("Middleware")]
    public class MiddlewareModel
    {
        [XmlElement("ModuleName", IsNullable = false)]
        public string ModuleName { get; set; }

        [XmlElement("VenderName", IsNullable = false)]
        public string VenderName { get; set; }

        [XmlElement("NsoName", IsNullable = false)]
        public string NsoName { get; set; }
    }
}
