﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Nintendo.Authoring.FileSystemMetaLibrary;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public interface ISource
    {
        long Size { get; }
        /// <summary>
        /// ISource のデータを指定したオフセットから指定したサイズ分読出し、実際に読み出せた分のサイズのバイト列を返します。
        /// </summary>
        ByteData PullData(long offset, int size);
        SourceStatus QueryStatus(); // Todo: long offset 引数
    }

    public interface IHierarchicalHashCalculatedSource : ISource
    {
        ISource GetMasterHashSource();
        ISource GetLayerHashSource();
        ISource GetFsHeaderSource(NintendoContentFileSystemInfo.EntryInfo entryInfo);
    }
}
