﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;
using Nintendo.Authoring.FileSystemMetaLibrary;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [XmlRoot("AuthoringToolInfo", IsNullable = false)]
    public class AuthoringToolInfoModel
    {
        [XmlElement("ToolVersion")]
        public string ToolVersion { get; set; }

        public AuthoringToolInfoModel()
        {
            var entryAssembly = Assembly.GetEntryAssembly();
            if(entryAssembly != null)
            {
                var toolVersion = entryAssembly.GetName().Version.ToString().Replace('.', '_');
                ToolVersion = string.Format("{0}:{1}", FileSystemMetaLibrary.NxAddonVersion.GetCurrentVersion(), toolVersion);
            }
            else
            {
                ToolVersion = "Invalid tool version.";
            }
        }

        public byte[] GetBytes()
        {
            var nameSpace = new XmlSerializerNamespaces();
            nameSpace.Add(String.Empty, String.Empty);

            using (var memoryStream = new MemoryStream())
            {
                var sw = new StreamWriter(memoryStream, Encoding.UTF8);
                var serializer = new XmlSerializer(typeof(AuthoringToolInfoModel));
                serializer.Serialize(sw, this, nameSpace);
                return memoryStream.ToArray();
            }
        }
    }

    public class AuthoringToolInfoXmlSource : ISource
    {
        public long Size { get; set; }
        private ISource m_source;

        public AuthoringToolInfoXmlSource() : this(new AuthoringToolInfoModel())
        {
        }

        public AuthoringToolInfoXmlSource(AuthoringToolInfoModel model)
        {
            var bytes = model.GetBytes();
            m_source = new MemorySource(bytes, 0, bytes.Length);
            Size = m_source.Size;
        }

        public ByteData PullData(long offset, int size)
        {
            return m_source.PullData(offset, size);
        }

        public SourceStatus QueryStatus()
        {
            return m_source.QueryStatus();
        }
    }

}
