﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace AOCommonLibrary
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// ストリームから読み書きするクラスです。
    /// </summary>
    public class StreamIO
    {
        /// <summary>
        /// ファイルからデータを読み込みます。
        /// </summary>
        /// <param name="filename">ファイルパス</param>
        /// <param name="waitTime">読み込み前のスリープ時間 [ms]</param>
        /// <returns>読み込んだ文字列</returns>
        public static string ReadData(string filename, int waitTime)
        {
            try
            {
                using (var reader = new StreamReader(filename))
                {
                    return ReadData(reader, waitTime);
                }
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: {0} の読み込みに失敗しました。", filename);
                throw;
            }
        }

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">読み込むストリーム</param>
        /// <param name="waitTime">読み込み前のスリープ時間 [ms]</param>
        /// <returns>読み込んだ文字列</returns>
        public static string ReadData(TextReader reader, int waitTime)
        {
            // TODO: パイプで前の標準出力から読み込む場合、少し待たないと ReadToEnd 関数でハマることがあるので暫定対処
            System.Threading.Thread.Sleep(waitTime);
            try
            {
                return reader.ReadToEnd();
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: データの読み込みに失敗しました。");
                throw;
            }
        }

        /// <summary>
        /// ファイルにデータを書き込みます。
        /// </summary>
        /// <param name="contents">書き込む文字列</param>
        /// <param name="filename">書き込み先ファイルパス</param>
        public static void WriteData(string contents, string filename)
        {
            try
            {
                using (var writer = new StreamWriter(filename, false, Encoding.UTF8))
                {
                    WriteData(contents, writer);
                }
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: {0} への書き込みに失敗しました。", filename);
                throw;
            }
        }

        /// <summary>
        /// ストリームにデータを書き込みます。
        /// </summary>
        /// <param name="contents">書き込む文字列</param>
        /// <param name="writer">書き込み先ストリーム</param>
        public static void WriteData(string contents, TextWriter writer)
        {
            try
            {
                writer.Write(contents);
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: データの書き込みに失敗しました。");
                throw;
            }
        }
    }
}
