﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

class IBlockStorage
{
public:
    virtual ~IBlockStorage() {}

    virtual uint64_t GetTotalSize() = 0;
    virtual uint64_t GetBlockSize() = 0;
    virtual uint64_t GetTotalBlocks() = 0;
    virtual nn::Result Write(uint64_t blockAddress, uint64_t numBlocks, const void* pData, size_t dataSize) = 0;
    virtual nn::Result Read(void* pOutBuffer, size_t bufferSize, uint64_t blockAddress, uint64_t numBlocks) = 0;
};
