﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/i2c/driver/i2c.h>

nn::Result ReadI2cRegister(
    uint8_t* pOutData,
    nn::i2c::driver::I2cSession& session,
    const uint8_t* pCmd, size_t cmdSize,
    size_t dataSize) NN_NOEXCEPT;

nn::Result WriteI2cRegister(
    nn::i2c::driver::I2cSession& session,
    const uint8_t* pCmd, size_t cmdSize,
    const uint8_t* pData,
    size_t dataSize) NN_NOEXCEPT;
