﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "systemInitializer_IFile.h"
#include <nn/fs_Base.h>

#if defined NN_TOOL_USE_CMAC_FILE

class FsFile : public IFile
{
public:
    FsFile() : m_Path(nullptr) {}
    virtual ~FsFile() {}

    virtual nn::Result OpenRead(const char *path);
    virtual nn::Result OpenWrite(const char *path);
    virtual void Close();
    virtual nn::Result Write(int64_t offset, const void* buffer, size_t size, bool flush);
    virtual nn::Result Read(size_t* pOut, int64_t offset, void* buffer, size_t size);
    virtual nn::Result GetSize(int64_t* pOut);
    virtual nn::Result Flush();
    virtual bool IsValid();
    static nn::Result Exists(bool *pOut, const char *path);
    static nn::Result Create(const char *path);
private:
    const char *m_Path;
};

#else

class FsFile : public IFile
{
public:
    virtual ~FsFile() {}

    virtual nn::Result OpenRead(const char *path);
    virtual nn::Result OpenWrite(const char *path);
    virtual void Close();
    virtual nn::Result Write(int64_t offset, const void* buffer, size_t size, bool flush);
    virtual nn::Result Read(size_t* pOut, int64_t offset, void* buffer, size_t size);
    virtual nn::Result GetSize(int64_t* pOut);
    virtual nn::Result Flush();
    virtual bool IsValid();
    static nn::Result Exists(bool *pOut, const char *path);
    static nn::Result Create(const char *path);
private:
    nn::fs::FileHandle m_Handle;
};

#endif
