﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "systemInitializer_FsBisPartition.h"

std::pair<nn::fs::BisPartitionId, const char*> s_FsBisPartitions[] = {
    std::make_pair(nn::fs::BisPartitionId::BootPartition1Root, "BootPartition1Root"),
    std::make_pair(nn::fs::BisPartitionId::BootPartition2Root, "BootPartition2Root"),
    std::make_pair(nn::fs::BisPartitionId::UserDataRoot, "UserDataRoot"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part1, "BootConfigAndPackage2Part1"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part2, "BootConfigAndPackage2Part2"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part3, "BootConfigAndPackage2Part3"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part4, "BootConfigAndPackage2Part4"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part5, "BootConfigAndPackage2Part5"),
    std::make_pair(nn::fs::BisPartitionId::BootConfigAndPackage2Part6, "BootConfigAndPackage2Part6"),
    std::make_pair(nn::fs::BisPartitionId::CalibrationBinary, "CalibrationBinary"),
    std::make_pair(nn::fs::BisPartitionId::CalibrationFile, "CalibrationFile"),
    std::make_pair(nn::fs::BisPartitionId::SafeMode, "SafeMode"),
    std::make_pair(nn::fs::BisPartitionId::User, "User"),
    std::make_pair(nn::fs::BisPartitionId::System, "System"),
    std::make_pair(nn::fs::BisPartitionId::SystemProperEncryption, "SystemProperEncryption")
};

std::pair<nn::fs::SaveDataSpaceId, const char*> s_FsSaveDataSpaceIds[] = {
    std::make_pair(nn::fs::SaveDataSpaceId::ProperSystem, "SystemProperEncryption"),
    std::make_pair(nn::fs::SaveDataSpaceId::SafeMode, "SafeMode"),
};

std::list<nn::fs::BisPartitionId> ListFsPartitions()
{
    std::list<nn::fs::BisPartitionId> ret;

    for(auto partition : s_FsBisPartitions)
    {
        ret.push_back(partition.first);
    }

    return ret;
}

std::string ConvertToBisPartitionName(nn::fs::BisPartitionId partitionId)
{
    for(auto partition : s_FsBisPartitions)
    {
        if(partition.first == partitionId)
        {
            return partition.second;
        }
    }

    NN_ABORT("Unknown BisPartitionId: %d", partitionId);
}

nn::fs::BisPartitionId ConvertToBisPartitionId(std::string partitionName)
{
    for(auto partition : s_FsBisPartitions)
    {
        if(partitionName == partition.second)
        {
            return partition.first;
        }
    }

    NN_ABORT("Unknown BisPartitionName: %s", partitionName.c_str());
}

nn::fs::SaveDataSpaceId ConvertToSaveDataSpaceId(std::string partitionName)
{
    for (auto spaceId : s_FsSaveDataSpaceIds)
    {
        if (partitionName == spaceId.second)
        {
            return spaceId.first;
        }
    }

    NN_ABORT("Unknown SaveDataSpaceId: %s", partitionName.c_str());

}


bool HasBisPartitionName(std::string partitionName)
{
    for(auto partition : s_FsBisPartitions)
    {
        if(partitionName == partition.second)
        {
            return true;
        }
    }

    return false;
}

bool HasSaveDataSpaceIdName(std::string partitionName)
{
    for (auto spaceId : s_FsSaveDataSpaceIds)
    {
        if (partitionName == spaceId.second)
        {
            return true;
        }
    }

    return false;
}
