﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <memory>
#include <Partition/systemInitializer_Partition.h>

class GptHolder
{
public:
    GptHolder();
    nn::Result Read(IBlockStorage *pStorage);

    GptHeader* GetHeader() { return m_pHeader.get(); }
    GptPartitionEntry* GetPartitions() { return m_pPartitions.get(); }

    static const size_t SizeOfPartitions = sizeof(GptPartitionEntry) * GPT_DEFAULT_PARTITION_ENTRIES;

private:
    std::unique_ptr<GptHeader> m_pHeader;
    std::unique_ptr<GptPartitionEntry> m_pPartitions;
};
