﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Types.h>

#include <nn/spl/impl/spl_ApiImpl.h>

namespace nn { namespace spl {

    class SecureMonitorManager
    {
    public:
        Result ModularExponentiate(
            void*       pResultBuffer,
            size_t      resultBufferSize,
            const void* pBase,
            size_t      baseSize,
            const void* pExponent,
            size_t      exponentSize,
            const void* pModulus,
            size_t      modulusSize ) NN_NOEXCEPT;
        Result GenerateAesKek(
            AccessKey*          pAccessKey,
            const void*         pKeySource,
            size_t              keySourceSize,
            int                 generation,
            int                 option ) NN_NOEXCEPT;
        Result LoadAesKey(
            int                 slotIndex,
            const void*         pOwner,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result GenerateAesKey(
            void*               pOutBuffer,
            size_t              outBufferSize,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result DecryptDeviceUniqueData(
            void*               pOutBuffer,
            size_t              outBufferSize,
            const void*         pData,
            size_t              dataSize,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result ReencryptDeviceUniqueData(
            void*               pOutBuffer,
            size_t              outBufferSize,
            const void*         pData,
            size_t              dataSize,
            const AccessKey&    accessKeyForDecryption,
            const void*         pKeySourceForDecryption,
            size_t              keySourceSizeForDecryption,
            const AccessKey&    accessKeyForEncryption,
            const void*         pKeySourceForEncryption,
            size_t              keySourceSizeForEncryption,
            Bit32               option ) NN_NOEXCEPT;
        Result GetConfig(
            Bit64*      pOut,
            ConfigItem  key ) NN_NOEXCEPT;
        Result SetConfig(
            ConfigItem  key,
            Bit64       value ) NN_NOEXCEPT;
        Result GetPackage2Hash(
            void*       pOutBuffer,
            size_t      bufferSize) NN_NOEXCEPT;
        Result  GenerateRandomBytes(
            void*       pOutBuffer,
            size_t      bufferSize ) NN_NOEXCEPT;
        Result  DecryptAndStoreGcKey(
            const void*         pData,
            size_t              dataSize,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result  DecryptGcMessage(
            int*        pOutResultSize,
            void*       pResultBuffer,
            size_t      resultBufferSize,
            const void* pCipher,
            size_t      cipherSize,
            const void* pModulus,
            size_t      modulusSize,
            const void* pLabelDigest,
            size_t      labelDigestSize) NN_NOEXCEPT;
        Result  DecryptAndStoreSslClientCertKey(
            const void*         pData,
            size_t              dataSize,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result  ModularExponentiateWithSslClientCertKey(
            void*       pResultBuffer,
            size_t      resultBufferSize,
            const void* pCipher,
            size_t      cipherSize,
            const void* pModulus,
            size_t      modulusSize) NN_NOEXCEPT;
        Result  DecryptAndStoreDrmDeviceCertKey(
            const void*         pData,
            size_t              dataSize,
            const AccessKey&    accessKey,
            const void*         pKeySource,
            size_t              keySourceSize ) NN_NOEXCEPT;
        Result  ModularExponentiateWithDrmDeviceCertKey(
            void*       pResultBuffer,
            size_t      resultBufferSize,
            const void* pCipher,
            size_t      cipherSize,
            const void* pModulus,
            size_t      modulusSize) NN_NOEXCEPT;
        Result IsDevelopment(bool* pIsDevelopment) NN_NOEXCEPT;
        Result GenerateSpecificAesKey(
            void*       pOutBuffer,
            size_t      outBufferSize,
            const void* pSource,
            size_t      sourceSize,
            int         generation,
            Bit32       purpose  ) NN_NOEXCEPT;
        Result DecryptAesKey(
            void*       pOutBuffer,
            size_t      outBufferSize,
            const void* pSource,
            size_t      sourceSize,
            int         generation,
            Bit32       option) NN_NOEXCEPT;
        Result ComputeCtr(
            void*       pOutBuffer,
            size_t      outBufferSize,
            int         slotIndex,
            const void* pOwner,
            const void* pInBuffer,
            size_t      inBufferSize,
            const void* pInitialCounter,
            size_t      initialCounterSize ) NN_NOEXCEPT;
        Result ComputeCmac(
            void*       pOutBuffer,
            size_t      outBufferSize,
            int         slotIndex,
            const void* pOwner,
            const void* pInBuffer,
            size_t      inBufferSize ) NN_NOEXCEPT;
        Result  LoadEsDeviceKey(
            const void*      pData,
            size_t           dataSize,
            const AccessKey& accessKey,
            const void*      pKeySource,
            size_t           keySourceSize) NN_NOEXCEPT;
        Result  PrepareEsTitleKey(
            AccessKey*       pAccessKey,
            const void*      pCipher,
            size_t           cipherSize,
            const void*      pModulus,
            size_t           modulusSize,
            const void*      pLabelDigest,
            size_t           labelDigestSize,
            int              generation) NN_NOEXCEPT;
        Result  PrepareEsArchiveKey(
            AccessKey*       pAccessKey,
            const void*      pCipher,
            size_t           cipherSize,
            const void*      pModulus,
            size_t           modulusSize,
            const void*      pLabelDigest,
            size_t           labelDigestSize,
            int              generation) NN_NOEXCEPT;
        Result PrepareCommonEsTitleKey(
            AccessKey*       pAccessKey,
            const void*      pKeySource,
            size_t           keySourceSize,
            int              generation) NN_NOEXCEPT;
        Result  LoadPreparedAesKey(
            int              slotIndex,
            const void*      pOwner,
            const AccessKey& accessKey) NN_NOEXCEPT;
        Result  AllocateAesKeySlot(
            int*        pSlotIndex,
            const void* pOwner ) NN_NOEXCEPT;
        Result  DeallocateAesKeySlot(
            int         slotIndex,
            const void* pOwner ) NN_NOEXCEPT;
        void    DeallocateAesKeySlots(
            const void* pOwner ) NN_NOEXCEPT;
        Result  GetAesKeySlotAvailableEvent(
            nn::os::SystemEvent** pEvent ) NN_NOEXCEPT;
        nn::os::SystemEvent* GetAesKeySlotAvailableEvent() NN_NOEXCEPT;
        Result  SetBootReason(BootReasonValue bootReason) NN_NOEXCEPT;
        Result GetBootReason(BootReasonValue* pOut) NN_NOEXCEPT;

    public:
        void Initialize() NN_NOEXCEPT;

    private:
        Result TestAesKeySlot(
            int         slotIndex,
            const void* pOwner ) NN_NOEXCEPT;

    private:
        const void* m_AesKeySlotOwners[impl::AesKeySlotCount];
    };

}}  // namespace nn::spl
