﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>

#include <nn/spl/spl_Api.h>
#include "spl_SecureMonitorManager.h"

namespace nn { namespace spl {

    class GeneralServer
    {
    public:
        explicit GeneralServer(SecureMonitorManager* p)
            : m_Manager(*p)
        {
        }

        nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT
        {
            return m_Manager.GetConfig(pOut.GetPointer(), static_cast<ConfigItem>(key));
        }

        nn::Result ModularExponentiate(
            const nn::sf::OutArray<nn::Bit8>& result,
            const nn::sf::InArray<nn::Bit8>& baseValue,
            const nn::sf::InArray<nn::Bit8>& exponent,
            const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
        {
            return m_Manager.ModularExponentiate(
                result.GetData(),
                result.GetLength(),
                baseValue.GetData(),
                baseValue.GetLength(),
                exponent.GetData(),
                exponent.GetLength(),
                modulus.GetData(),
                modulus.GetLength() );
        }

        nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT
        {
            return m_Manager.SetConfig(static_cast<ConfigItem>(key), value);
        }

        nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
        {
            return m_Manager.GenerateRandomBytes(result.GetData(), result.GetLength());
        }

        nn::Result IsDevelopment(
            nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT
        {
            return m_Manager.IsDevelopment(&*isDevelopment);
        }

        Result SetBootReason(
            BootReasonValue bootReason) NN_NOEXCEPT
        {
            return m_Manager.SetBootReason( bootReason );
        }

        Result GetBootReason(
            nn::sf::Out<BootReasonValue> bootReason) NN_NOEXCEPT
        {
            return m_Manager.GetBootReason( &*bootReason );
        }

    protected:
        SecureMonitorManager&   m_Manager;
    };

}}  // namespace nn::spl
