﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>

#include <nn/spl/spl_Api.h>
#include "spl_DeviceUniqueDataServer.h"

namespace nn { namespace spl {

    class EsServer : public DeviceUniqueDataServer
    {
    public:
        explicit EsServer(SecureMonitorManager* p)
            : DeviceUniqueDataServer(p)
        {
        }

        nn::Result LoadEsDeviceKey(
            const nn::sf::InArray<nn::Bit8>& data,
            const nn::spl::AccessKey& accessKey,
            const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            return m_Manager.LoadEsDeviceKey(
                data.GetData(),
                data.GetLength(),
                accessKey,
                &keySource,
                sizeof(keySource) );
        }

        nn::Result PrepareEsTitleKey(
            nn::sf::Out<nn::spl::AccessKey> accessKey,
            const nn::sf::InArray<nn::Bit8>& cipher,
            const nn::sf::InArray<nn::Bit8>& modulus,
            const nn::sf::InArray<nn::Bit8>& labelDigest,
            std::int32_t generation) NN_NOEXCEPT
        {
            return m_Manager.PrepareEsTitleKey(
                &*accessKey,
                cipher.GetData(),
                cipher.GetLength(),
                modulus.GetData(),
                modulus.GetLength(),
                labelDigest.GetData(),
                labelDigest.GetLength(),
                generation );
        }

        nn::Result PrepareEsArchiveKey(
            nn::sf::Out<nn::spl::AccessKey> accessKey,
            const nn::sf::InArray<nn::Bit8>& cipher,
            const nn::sf::InArray<nn::Bit8>& modulus,
            const nn::sf::InArray<nn::Bit8>& labelDigest,
            std::int32_t generation) NN_NOEXCEPT
        {
            return m_Manager.PrepareEsArchiveKey(
                &*accessKey,
                cipher.GetData(),
                cipher.GetLength(),
                modulus.GetData(),
                modulus.GetLength(),
                labelDigest.GetData(),
                labelDigest.GetLength(),
                generation );
        }

        nn::Result PrepareCommonEsTitleKey(
            nn::sf::Out<nn::spl::AccessKey> accessKey,
            const nn::spl::detail::KeySource& keySource,
            std::int32_t generation) NN_NOEXCEPT
        {
            return m_Manager.PrepareCommonEsTitleKey(
                &*accessKey,
                &keySource,
                sizeof(keySource),
                generation );
        }

        nn::Result LoadPreparedAesKey(
            std::int32_t slotIndex,
            const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
        {
            return m_Manager.LoadPreparedAesKey(
                slotIndex,
                this,
                accessKey );
        }

        nn::Result DecryptAndStoreDrmDeviceCertKey(
            const nn::sf::InArray<nn::Bit8>& data,
            const nn::spl::AccessKey& accessKey,
            const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            return m_Manager.DecryptAndStoreDrmDeviceCertKey(
                data.GetData(),
                data.GetLength(),
                accessKey,
                &keySource,
                sizeof(keySource) );
        }

        nn::Result ModularExponentiateWithDrmDeviceCertKey(
            const nn::sf::OutArray<nn::Bit8>& result,
            const nn::sf::InArray<nn::Bit8>& cipher,
            const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT
        {
            return m_Manager.ModularExponentiateWithDrmDeviceCertKey(
                result.GetData(),
                result.GetLength(),
                cipher.GetData(),
                cipher.GetLength(),
                modulus.GetData(),
                modulus.GetLength());
        }
    };

}}  // namespace nn::spl
