﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sm/sm_Result.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Result.h>
#include <cstring>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_ContextControl.h>

#include "sm_WaitList.h"

namespace nn { namespace sm {

    namespace
    {
        const int ProcessCountMax = 64;

        struct WaitEntry
        {
            ServiceName                 key;
            os::MultiWaitHolderType*    pSession;
        };

        WaitEntry   g_Entries[ProcessCountMax];
        WaitEntry*  g_pProcessingEntry;
        ServiceName g_TriggeredKey;

        WaitEntry* Find(ServiceName key)
        {
            for( int i = 0; i < ProcessCountMax; ++i )
            {
                if( g_Entries[i].key == key )
                {
                    return &g_Entries[i];
                }
            }

            return NULL;
        }


    }   // anonoymouse namespace



    Result StartRegisterRetry(ServiceName key)
    {
        NN_ABORT_UNLESS( g_pProcessingEntry == NULL );

        auto pwe = Find(ServiceName::InvalidName);
        if( pwe == NULL )
        {
            return ResultMaxProcess();
        }

        pwe->key = key;
        pwe->pSession = NULL;

        g_pProcessingEntry = pwe;

        return nn::sf::DeferProcess();
    }

    void ProcessRegisterRetry(os::MultiWaitHolderType* pSession)
    {
        NN_ABORT_UNLESS( g_pProcessingEntry != NULL );

        g_pProcessingEntry->pSession = pSession;
        g_pProcessingEntry = NULL;
    }

    void TriggerResume(ServiceName key)
    {
        NN_ABORT_UNLESS( g_TriggeredKey == ServiceName::InvalidName );
        g_TriggeredKey = key;
    }

    void TestAndResume(ResumeImplFuncType resume)
    {
        if( g_TriggeredKey == ServiceName::InvalidName )
        {
            return;
        }

        for( int i = 0; i < ProcessCountMax; ++i )
        {
            if( g_Entries[i].key == g_TriggeredKey )
            {
                Result result = resume(g_Entries[i].pSession);
                NN_ABORT_UNLESS_RESULT_SUCCESS(result);
                g_Entries[i].key = ServiceName::InvalidName;
            }
        }

        g_TriggeredKey = ServiceName::InvalidName;
    }


}}  // namespace nn::sm
