﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sm/sm_Types.h>
#include <nn/sm/sm_Result.public.h>
#include <nn/os/os_Types.h>
#include <nn/svc/svc_Types.h>
#include <nn/sf/sf_NativeHandle.h>

#include "sm_ServiceManager.h"

namespace nn { namespace sm {

    class UserInterface
    {
    public:
        UserInterface()
        {
            m_IsRegisterd = false;
            m_Id.value    = static_cast<Bit64>(-1ll);
        }

        ~UserInterface()
        {
            if (m_IsRegisterd)
            {
                sm::UnregisterAllServices(m_Id);
            }
        }

        nn::Result RegisterClient(nn::Bit64 processId) NN_NOEXCEPT
        {
            m_Id.value = processId;
            m_IsRegisterd = true;
            return ResultSuccess();
        }
        nn::Result GetServiceHandle(nn::sf::Out<nn::sf::NativeHandle> outStorage, nn::sm::ServiceName name) NN_NOEXCEPT
        {
            if (m_IsRegisterd == false)
            {
                return ResultInvalidClient();
            }

            svc::Handle handle;
            auto r = sm::GetServiceHandle(&handle, m_Id, name);
            outStorage.Set(sf::NativeHandle(handle.operator nnHandle().value, true));
            return r;
        }
        nn::Result RegisterService(nn::sf::Out<nn::sf::NativeHandle> outStorage, nn::sm::ServiceName name, int sessionCountMax, bool isLight) NN_NOEXCEPT
        {
            if (m_IsRegisterd == false)
            {
                return ResultInvalidClient();
            }

            svc::Handle handle;
            auto r = sm::RegisterService(&handle, m_Id, name, sessionCountMax, isLight);
            outStorage.Set(sf::NativeHandle(handle.operator nnHandle().value, true));
            return r;
        }
        nn::Result UnregisterService(nn::sm::ServiceName name) NN_NOEXCEPT
        {
            if (m_IsRegisterd == false)
            {
                return ResultInvalidClient();
            }

            return sm::UnregisterService(m_Id, name);
        }

    private:
        os::ProcessId   m_Id;
        bool            m_IsRegisterd;
    };

}}  // namespace nn::sm
