﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/svc/svc_Base.h>
#include <nn/ldr/ldr_ProcessManagerApi.h>

namespace nn { namespace pm {

    Result InitializeSpec() NN_NOEXCEPT;
    Result BoostSystemMemoryResourceLimit(int64_t boostSize) NN_NOEXCEPT;

    svc::Handle GetResourceLimit(const ldr::ProgramInfo& pi) NN_NOEXCEPT;
    void WaitResource(const ldr::ProgramInfo& pi) NN_NOEXCEPT;


}}  // namespace nn::pm

