﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/os/os_Types.h>
#include "pm_ProcessManager.h"

namespace nn { namespace pm {

    class ShellInterfaceServer
    {
    public:
        nn::Result LaunchProgram(nn::sf::Out<nn::os::ProcessId> out, const ncm::ProgramLocation& location, std::int32_t flags) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->LaunchProgram(out.GetPointer(), location, flags);
        }
        nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->TerminateProcess(id);
        }
        nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->TerminateProgram(id);
        }
        nn::Result GetProcessEventHandle(nn::sf::Out<nn::sf::NativeHandle> out) NN_NOEXCEPT
        {
            nn::svc::Handle handle;
            auto ret = ProcessManager::GetInstance()->GetProcessEventHandle(&handle);
            out.Set(nn::sf::NativeHandle(handle.operator nnHandle().value, false));
            return ret;
        }
        nn::Result GetProcessEventInfo(nn::sf::Out<nn::pm::ProcessEventInfo> out) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->GetProcessEventInfo(out.GetPointer());
        }
        nn::Result GetApplicationProcessIdForShell(nn::sf::Out<nn::os::ProcessId> out) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->GetApplicationProcessId(out.GetPointer());
        }
        nn::Result NotifyBootFinished() NN_NOEXCEPT
        {
            ProcessManager::GetInstance()->NotifyBootFinished();
            return ResultSuccess();
        }
        nn::Result BoostSystemMemoryResourceLimit(int64_t boostSize) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->BoostSystemMemoryResourceLimit(boostSize);
        }
    };

}}  // namespace nn::pm
