﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/fs/fs_File.h>

#include "ldr_DataTypes.h"

namespace nn { namespace ldr {

    class MetaLoader
    {
    public:
        struct Npdm
        {
            const Meta*             pMeta;
            const AcidHeaderData*   pAcid;
            const AciHeader*        pAci;

            const void*             pFacd;
            const void*             pSacd;
            const void*             pKcd;

            const void*             pFac;
            const void*             pSac;
            const void*             pKc;
        };

    public:
        MetaLoader() NN_NOEXCEPT
        {
            m_CachedProgramId.value = 0;
        }
        Result Load(Npdm* pNpdm, ncm::ProgramId id) NN_NOEXCEPT;
        Result GetCachedOrLoad(Npdm* pNpdm, ncm::ProgramId id) NN_NOEXCEPT;

    private:
        NN_ALIGNAS(512) Bit8    m_NpdmBuffer[32 * 1024];
        Npdm                    m_NpdmCache;
        ncm::ProgramId          m_CachedProgramId;
    };

}}  // namespace nn::ldr
