﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/svc/svc_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>
#include <nn/os/os_Types.h>
#include <nn/ldr/ldr_Types.h>

#include "ldr_ArgumentStore.h"

namespace nn { namespace ldr {

    enum MemoryRegion
    {
        MemoryRegion_Application     = 0,
        MemoryRegion_Applet          = 1,
        MemoryRegion_SecureSystem    = 2,
        MemoryRegion_NonSecureSystem = 3,
    };

    Result CreateProcess(
            svc::Handle*                    pOut,
            ldr::PinId                      pinId,
            const char*                     pProgramPath,
            const ArgumentStore::Entry*     pArgument,
            int                             flags,
            svc::Handle                     resourceLimit) NN_NOEXCEPT;

    Result GetProgramInfo(
            ProgramInfo*                    pOut,
            ncm::ProgramId                  programId,
            const char*                     pProgramPath ) NN_NOEXCEPT;

    Result PinProgram(
            PinId*                          pOutId,
            const ncm::ProgramLocation&     programLocation) NN_NOEXCEPT;

    Result UnpinProgram(
            PinId                           id) NN_NOEXCEPT;

    Result GetProcessModuleInfo(
            int*                            pOutCount,
            ldr::ModuleInfo*                pBuffer,
            int                             num,
            os::ProcessId                   id ) NN_NOEXCEPT;



    Result GetProgramLocationFromPinId(ncm::ProgramLocation* outValue, PinId pinId) NN_NOEXCEPT;

}}  // namespace nn::ldr
