﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nn_Result.h>

#include <nn/dt/server/dt_Server.h>
#include <nn/init.h>
#include <nn/os/os_Thread.h>

#include "dt_StartServer.h"

namespace nn { namespace dt {

namespace
{
    const size_t ThreadStackSize = 16 * 1024;
    NN_ALIGNAS(4096) uint8_t g_ThreadStack[ThreadStackSize];
    nn::os::ThreadType g_Thread;

    void ServerThread(void *)
    {
        nn::dt::server::Initialize();
        nn::dt::server::StartHipcServer();
        nn::dt::server::LoopHipcServer();
    };
}

void InitializeServer() NN_NOEXCEPT
{
    nn::dt::server::RegisterHipcServer();
}

void StartServer() NN_NOEXCEPT
{
    nn::os::CreateThread(&g_Thread, ServerThread, nullptr, g_ThreadStack, ThreadStackSize, NN_SYSTEM_THREAD_PRIORITY(dt, IpcServer));
    nn::os::SetThreadNamePointer(&g_Thread, NN_SYSTEM_THREAD_NAME(dt, IpcServer));
    nn::os::StartThread(&g_Thread);
}

}}
