﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nsd/server/nsd_ApiForServer.h>
#include <cstdlib>

#if NN_NETWORK_USE_BSDSOCKET

#include <nn/init.h>
#include <nn/eth/server/eth_EthServer.h>
#include <nn/bsdsocket/cfg/cfg_ServerApi.h>
#include <nn/time.h>

#include "bsdsocket_Server.h"
#include "bsdsocket_Wlan.h"
#include "bsdsocket_Ethernet.h"
#include "bsdsocket_Main.config.h"

#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/socket/resolver/resolver_Server.h>

NN_ALIGNAS(4096) uint8_t g_MallocMemoryPoolBuffer[MallocMemoryPoolSize];
NN_ALIGNAS(4096) uint8_t g_EthMemory[EthMemoryPoolSize];

static nn::socket::SystemConfigLightDefaultWithMemory
    <
        8,     // TCP sockets: resolver uses up to (8)
        8 + 2  // UDP sockets: resolver uses up to (8), plus up to (2) for CFG + DHCP
    > g_SocketConfigWithMemory(8 + 2);

extern "C"
{
int ResolverCacheInitialize();
}

extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_MallocMemoryPoolBuffer, sizeof(g_MallocMemoryPoolBuffer));
}

extern "C" void nnMain()
{
    // seed PRNG
    std::srand(static_cast<unsigned int>(nn::os::GetSystemTick().GetInt64Value()));

    // initialize the resolver cache (memory and other objects)
    ResolverCacheInitialize();

    // socket service
    nn::socket::InitializeServer();

    // initialize resolver server service framework server
    nn::socket::resolver::InitializeServer();

    // bsd interface configuration
    nn::bsdsocket::cfg::InitializeServer();

    // usb interface configuration
    nn::eth::server::Initialize(g_EthMemory, EthMemoryPoolSize);

#if NN_DETAIL_BSDSOCKET_ENABLE_WLAN
    // wlan interface
    nn::eth::wlan::InitializeWlan();
#endif

    // usb configuration client, temporary in place of NIFM
    nn::eth::client::EthClientInit();

#if NN_DETAIL_BSDSOCKET_ENABLE_NSD
    // initialize time for NSD server.
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::Initialize());

    // Begin the NSD server
    nn::nsd::server::StartServer();
#endif

    // initialize the client socket layer, needed for bionic resolver server
    nn::socket::Initialize(g_SocketConfigWithMemory);

    nn::socket::Wait();
}

#else

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    return;
}

#endif
